/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.plugins.hide;

import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import edu.caltech.ssel.multistage.plugins.hide.AccumulatingEntry;
import edu.caltech.ssel.multistage.plugins.hide.HidePanel;
import edu.caltech.ssel.multistage.plugins.hide.HintPanel;
import edu.caltech.ssel.multistage.plugins.hide.SeekPanel;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class HideGUI
extends ClientGUI {
    private JPanel HistoryPanel;
    private int index;
    private int hidePosition;
    private int hideHint;
    private int accumulatingSize;
    private JPanel contentPanel;
    private JButton okButton;
    private String type;
    private String okButtonLabel;
    private String hideText;
    private String hideWaitText;
    private String presentImage;
    private String seekText;
    private String seekWaitText;
    private String hideHintText;
    private String youHideText;
    private String pointsText;
    private String otherHideText;
    private String otherPointsText;
    private String totalText;
    private String farmerImage;
    private String pirateImage;
    private String smileImage;
    private String frownImage;
    private String accumulatingImage;
    private ArrayList<String> hiderData;
    private ArrayList<String> seekerData;
    private ArrayList<String> accumulatingData;
    private ArrayList<float[]> hiderPositions;
    private ArrayList<float[]> seekerPositions;
    private ArrayList<float[]> accumulatingPositions;
    private ArrayList<Float> hiderPays;
    private ArrayList<Float> seekerPays;
    private boolean useHideHint;
    private boolean hideDone;
    private boolean hintDone;
    private boolean showTokens;
    private boolean showAccumulatingFeedback;
    private boolean showSummaryImages;
    private boolean showFacesOnAccumulatingFeedback;
    private float[] positionPayoffs;
    private long startTime;
    private long hideTime;
    private long hintTime;
    private long seekTime;
    public static Category log = Logger.getLogger(HideGUI.class);

    private void initComponents() {
        this.HistoryPanel = new JPanel();
        this.HistoryPanel.setLayout(new BoxLayout(this.HistoryPanel, 1));
        this.HistoryPanel.add((Component)this.clientHistory);
        this.contentPanel = new JPanel();
        this.contentPanel.setBackground(Color.WHITE);
        this.contentPanel.setLayout(new GridBagLayout());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.contentPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HideGUI.this.exitForm(evt);
            }
        });
    }

    public void initialize() {
        this.initComponents();
        this.rand = new Random();
        this.setVisible(false);
    }

    private void exitForm(WindowEvent evt) {
        this.exit();
    }

    public static void main(String[] args) {
    }

    protected void constructLayout(Information info, ClientData clientData) {
        try {
            this.type = info.getStringInfo((Object)"type");
            System.out.println("type==" + this.type);
            if (this.type.equalsIgnoreCase("hide")) {
                this.hideText = info.getStringInfo((Object)"hideText");
                this.okButtonLabel = info.getStringInfo((Object)"okButtonLabel");
                this.index = info.getIntInfo((Object)"index");
                this.positionPayoffs = (float[])info.getInfo((Object)"positionPayoffs");
                this.presentImage = info.getStringInfo((Object)"presentImage");
                this.useHideHint = info.getBooleanInfo((Object)"useHideHint");
                this.showTokens = info.getBooleanInfo((Object)"showTokens");
                this.farmerImage = info.getStringInfo((Object)"farmerImage");
                this.accumulatingSize = info.getIntInfo((Object)"accumulatingSize");
                if (this.useHideHint) {
                    this.hideHintText = info.getStringInfo((Object)"hideHintText");
                }
                this.showAccumulatingFeedback = info.getBooleanInfo((Object)"showAccumulatingFeedback");
                this.showFacesOnAccumulatingFeedback = info.getBooleanInfo((Object)"showFacesOnAccumulatingFeedback");
                this.accumulatingImage = info.getStringInfo((Object)"accumulatingImage");
                if (this.showAccumulatingFeedback) {
                    this.accumulatingData = (ArrayList)info.getInfo((Object)"accumulatingData");
                    this.accumulatingPositions = (ArrayList)info.getInfo((Object)"accumulatingPositions");
                    this.smileImage = info.getStringInfo((Object)"smileImage");
                    this.frownImage = info.getStringInfo((Object)"frownImage");
                }
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        HideGUI.this.constructHideLayout();
                    }
                });
            } else if (this.type.equalsIgnoreCase("hideWait")) {
                this.index = info.getIntInfo((Object)"index");
                this.hideWaitText = info.getStringInfo((Object)"hideWaitText");
                this.showTokens = info.getBooleanInfo((Object)"showTokens");
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        HideGUI.this.constructHideWaitLayout();
                    }
                });
                this.makeMove();
            } else if (this.type.equalsIgnoreCase("seek")) {
                this.index = info.getIntInfo((Object)"index");
                this.seekText = info.getStringInfo((Object)"seekText");
                this.okButtonLabel = info.getStringInfo((Object)"okButtonLabel");
                this.hidePosition = info.getIntInfo((Object)"hidePosition");
                this.positionPayoffs = (float[])info.getInfo((Object)"positionPayoffs");
                this.presentImage = info.getStringInfo((Object)"presentImage");
                this.hideHint = info.getIntInfo((Object)"hideHint");
                this.showTokens = info.getBooleanInfo((Object)"showTokens");
                this.pirateImage = info.getStringInfo((Object)"pirateImage");
                this.showAccumulatingFeedback = info.getBooleanInfo((Object)"showAccumulatingFeedback");
                this.showFacesOnAccumulatingFeedback = info.getBooleanInfo((Object)"showFacesOnAccumulatingFeedback");
                this.accumulatingImage = info.getStringInfo((Object)"accumulatingImage");
                this.accumulatingSize = info.getIntInfo((Object)"accumulatingSize");
                if (this.showAccumulatingFeedback) {
                    this.accumulatingData = (ArrayList)info.getInfo((Object)"accumulatingData");
                    this.accumulatingPositions = (ArrayList)info.getInfo((Object)"accumulatingPositions");
                    this.smileImage = info.getStringInfo((Object)"smileImage");
                    this.frownImage = info.getStringInfo((Object)"frownImage");
                }
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        HideGUI.this.constructSeekLayout();
                    }
                });
            } else if (this.type.equalsIgnoreCase("seekWait")) {
                this.index = info.getIntInfo((Object)"index");
                this.seekWaitText = info.getStringInfo((Object)"seekWaitText");
                this.showTokens = info.getBooleanInfo((Object)"showTokens");
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        HideGUI.this.constructSeekWaitLayout();
                    }
                });
                this.makeMove();
            } else if (this.type.equalsIgnoreCase("summary")) {
                this.farmerImage = info.getStringInfo((Object)"farmerImage");
                this.pirateImage = info.getStringInfo((Object)"pirateImage");
                this.smileImage = info.getStringInfo((Object)"smileImage");
                this.frownImage = info.getStringInfo((Object)"frownImage");
                this.totalText = info.getStringInfo((Object)"totalText");
                this.hiderData = (ArrayList)info.getInfo((Object)"hiderData");
                this.seekerData = (ArrayList)info.getInfo((Object)"seekerData");
                this.hiderPositions = (ArrayList)info.getInfo((Object)"hiderPositions");
                this.seekerPositions = (ArrayList)info.getInfo((Object)"seekerPositions");
                this.hiderPays = (ArrayList)info.getInfo((Object)"hiderPays");
                this.seekerPays = (ArrayList)info.getInfo((Object)"seekerPays");
                this.showSummaryImages = info.getBooleanInfo((Object)"showSummaryImages");
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        HideGUI.this.constructSummaryLayout();
                    }
                });
            }
            Runnable doUpdate = new Runnable(){

                public void run() {
                    if (!HideGUI.this.isVisible()) {
                        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                        HideGUI.this.setSize(screen);
                        int iCenterX = screen.width / 2;
                        int iCenterY = screen.height / 2;
                        HideGUI.this.setLocation(iCenterX - screen.width / 2, iCenterY - screen.height / 2);
                    }
                    HideGUI.this.setVisible(true);
                }
            };
            SwingUtilities.invokeAndWait(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)"Failed to construct game layout");
            e.printStackTrace();
        }
    }

    private void constructWaitingLayout() {
    }

    private void constructHideWaitLayout() {
        this.startTime = System.currentTimeMillis();
        this.contentPanel.removeAll();
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Font labelFont = new Font("Arial", 1, 24);
        JLabel waitLabel = new JLabel(this.parseString(this.hideWaitText), 0);
        waitLabel.setFont(labelFont);
        this.contentPanel.add((Component)waitLabel, c);
        this.validate();
        this.repaint();
    }

    private void constructSeekWaitLayout() {
        this.startTime = System.currentTimeMillis();
        this.contentPanel.removeAll();
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Font labelFont = new Font("Arial", 1, 24);
        JLabel waitLabel = new JLabel(this.parseString(this.seekWaitText), 0);
        waitLabel.setFont(labelFont);
        this.contentPanel.add((Component)waitLabel, c);
        this.validate();
        this.repaint();
    }

    private void constructHideLayout() {
        this.startTime = System.currentTimeMillis();
        this.contentPanel.removeAll();
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Font labelFont = new Font("Arial", 1, 16);
        JLabel feedImage = new JLabel();
        JPanel feedback = new JPanel(new GridBagLayout());
        feedback.setBackground(Color.WHITE);
        GridBagConstraints fc = new GridBagConstraints();
        fc.gridy = 0;
        fc.anchor = 11;
        fc.weighty = this.accumulatingData == null || this.accumulatingData.size() == 0 ? 1.0 : 0.0;
        feedback.add((Component)feedImage, fc);
        ImageIcon raw = new ImageIcon(this.accumulatingImage);
        float ratio = (0.0f + (float)raw.getIconHeight()) / (float)raw.getIconWidth();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        feedImage.setIcon(new ImageIcon(raw.getImage().getScaledInstance((int)((float)(3 * screen.height / 24) / ratio), 3 * screen.height / 24, 4)));
        if (this.showAccumulatingFeedback) {
            DecimalFormat df = new DecimalFormat("0");
            for (int i = 0; i < this.accumulatingData.size(); ++i) {
                int seekPos;
                String s = this.accumulatingData.get(i);
                StringTokenizer tok = new StringTokenizer(s, ",");
                int hidePos = Integer.parseInt(tok.nextToken());
                AccumulatingEntry entry = new AccumulatingEntry(hidePos == (seekPos = Integer.parseInt(tok.nextToken())) ? this.frownImage : this.smileImage, String.valueOf(df.format(this.accumulatingPositions.get(i)[hidePos])), this.accumulatingSize);
                if (!this.showFacesOnAccumulatingFeedback) {
                    entry.showFaces(false);
                }
                ++fc.gridy;
                fc.weighty = i == this.accumulatingData.size() - 1 ? 1.0 : 0.0;
                feedback.add((Component)entry, fc);
            }
        }
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 5;
        c.anchor = 11;
        this.contentPanel.add((Component)feedback, c);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        final HidePanel hide = new HidePanel(this.presentImage, this.positionPayoffs, this);
        hide.setDrawTokens(this.showTokens);
        hide.setPreferredSize(new Dimension(4 * size.width / 9, 4 * size.width / 9 + 75));
        final HintPanel hint = new HintPanel(this.positionPayoffs, this);
        hint.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        hint.setDrawTokens(this.showTokens);
        hint.setPreferredSize(new Dimension(size.height / 2, size.height / 2 + 75));
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 5;
        c.insets = new Insets(0, 0, 0, 20);
        c.anchor = 10;
        this.contentPanel.add((Component)hide, c);
        JLabel hideLabel = new JLabel(this.parseString(this.hideText), 0);
        hideLabel.setFont(labelFont);
        this.okButton = new JButton(this.parseString(this.okButtonLabel));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HideGUI.this.addIntInfo("hidingSpot", hide.getHidingSpot());
                HideGUI.this.addStringInfo("hideTime", String.valueOf(HideGUI.this.hideTime));
                HideGUI.this.okButton.setEnabled(false);
                hide.setEnabled(false);
                if (HideGUI.this.useHideHint) {
                    HideGUI.this.addIntInfo("hintSpot", hint.getHidingSpot());
                    HideGUI.this.addStringInfo("hintTime", String.valueOf(HideGUI.this.hintTime));
                    hint.setEnabled(false);
                }
                HideGUI.this.makeMove();
            }
        });
        this.okButton.setEnabled(false);
        c.gridx = 2;
        c.gridy = 0;
        c.gridheight = 1;
        c.insets = new Insets(10, 0, 10, 0);
        if (this.useHideHint) {
            c.anchor = 18;
            c.weighty = 1.0;
        } else {
            c.anchor = 15;
            c.weighty = 0.0;
        }
        this.contentPanel.add((Component)hideLabel, c);
        c.gridy = 2;
        c.weighty = this.useHideHint ? 1.0 : 0.0;
        c.insets = new Insets(0, 0, 20, 0);
        c.anchor = 11;
        this.contentPanel.add((Component)this.okButton, c);
        JLabel hintInstructions = new JLabel(this.parseString(this.hideHintText), 0);
        hintInstructions.setFont(labelFont);
        c.gridy = 3;
        c.weighty = 0.0;
        c.anchor = 11;
        if (this.useHideHint) {
            this.contentPanel.add((Component)hintInstructions, c);
            c.gridy = 4;
            c.gridheight = 1;
            this.contentPanel.add((Component)hint, c);
        }
        this.validate();
        this.repaint();
    }

    private void constructSeekLayout() {
        this.startTime = System.currentTimeMillis();
        this.contentPanel.removeAll();
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Font labelFont = new Font("Arial", 1, 16);
        JPanel feedback = new JPanel(new GridBagLayout());
        feedback.setBackground(Color.WHITE);
        GridBagConstraints fc = new GridBagConstraints();
        JLabel feedImage = new JLabel();
        ImageIcon raw = new ImageIcon(this.accumulatingImage);
        float ratio = (0.0f + (float)raw.getIconHeight()) / (float)raw.getIconWidth();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        System.out.println("seeker accumulatingImage=" + this.accumulatingImage);
        feedImage.setIcon(new ImageIcon(raw.getImage().getScaledInstance((int)((float)(3 * screen.height / 24) / ratio), 3 * screen.height / 24, 4)));
        fc.gridy = 0;
        fc.anchor = 11;
        fc.weighty = this.accumulatingData == null || this.accumulatingData.size() == 0 ? 1.0 : 0.0;
        feedback.add((Component)feedImage, fc);
        if (this.showAccumulatingFeedback) {
            DecimalFormat df = new DecimalFormat("0");
            for (int i = 0; i < this.accumulatingData.size(); ++i) {
                int seekPos;
                String s = this.accumulatingData.get(i);
                StringTokenizer tok = new StringTokenizer(s, ",");
                int hidePos = Integer.parseInt(tok.nextToken());
                AccumulatingEntry entry = new AccumulatingEntry(hidePos == (seekPos = Integer.parseInt(tok.nextToken())) ? this.smileImage : this.frownImage, String.valueOf(df.format(this.accumulatingPositions.get(i)[seekPos])), this.accumulatingSize);
                if (!this.showFacesOnAccumulatingFeedback) {
                    entry.showFaces(false);
                }
                ++fc.gridy;
                fc.weighty = i == this.accumulatingData.size() - 1 ? 1.0 : 0.0;
                feedback.add((Component)entry, fc);
            }
        }
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 4;
        c.anchor = 11;
        this.contentPanel.add((Component)feedback, c);
        final SeekPanel seek = new SeekPanel(this.presentImage, this.positionPayoffs, this, this.hidePosition, this.hideHint);
        seek.setDrawTokens(this.showTokens);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        seek.setPreferredSize(new Dimension(4 * size.width / 9, 4 * size.width / 9 + 75));
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        c.insets = new Insets(0, 0, 0, 20);
        this.contentPanel.add((Component)seek, c);
        JLabel seekLabel = new JLabel(this.parseString(this.seekText), 0);
        seekLabel.setFont(labelFont);
        this.okButton = new JButton(this.parseString(this.okButtonLabel));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HideGUI.this.addIntInfo("seekSpot", seek.getHidingSpot());
                HideGUI.this.addStringInfo("seekTime", String.valueOf(HideGUI.this.seekTime));
                HideGUI.this.makeMove();
                HideGUI.this.okButton.setEnabled(false);
                seek.setEnabled(false);
            }
        });
        this.okButton.setEnabled(false);
        c.gridx = 2;
        c.gridheight = 1;
        c.insets = new Insets(10, 0, 10, 0);
        c.anchor = 15;
        c.weighty = 1.0;
        this.contentPanel.add((Component)seekLabel, c);
        c.gridy = 1;
        c.anchor = 11;
        c.weighty = 1.0;
        this.contentPanel.add((Component)this.okButton, c);
        this.validate();
        this.repaint();
    }

    private void constructSummaryLayout() {
        this.contentPanel.removeAll();
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Font labelFont = new Font("Arial", 1, 40);
        int hiderGood = 0;
        int hiderBad = 0;
        int seekerGood = 0;
        int seekerBad = 0;
        ArrayList<Integer> hiderhide = new ArrayList<Integer>();
        ArrayList<Integer> hiderseek = new ArrayList<Integer>();
        for (String s : this.hiderData) {
            StringTokenizer tok = new StringTokenizer(s, ",");
            hiderhide.add(Integer.parseInt(tok.nextToken()));
            hiderseek.add(Integer.parseInt(tok.nextToken()));
        }
        for (int i = 0; i < hiderhide.size(); ++i) {
            if (hiderhide.get(i) == hiderseek.get(i)) {
                ++hiderBad;
                continue;
            }
            ++hiderGood;
        }
        ArrayList<Integer> seekerhide = new ArrayList<Integer>();
        ArrayList<Integer> seekerseek = new ArrayList<Integer>();
        for (String s : this.seekerData) {
            StringTokenizer tok = new StringTokenizer(s, ",");
            seekerhide.add(Integer.parseInt(tok.nextToken()));
            seekerseek.add(Integer.parseInt(tok.nextToken()));
        }
        for (int i = 0; i < seekerhide.size(); ++i) {
            if (seekerhide.get(i) == seekerseek.get(i)) {
                ++seekerGood;
                continue;
            }
            ++seekerBad;
        }
        if (this.showSummaryImages) {
            JLabel hider = new JLabel();
            hider.setIcon(new ImageIcon(this.farmerImage));
            JLabel hiderSmile = new JLabel();
            hiderSmile.setIcon(new ImageIcon(this.smileImage));
            JLabel hiderSmileCount = new JLabel(":" + hiderGood, 0);
            hiderSmileCount.setFont(labelFont);
            JLabel hiderFrown = new JLabel();
            hiderFrown.setIcon(new ImageIcon(this.frownImage));
            JLabel hiderFrownCount = new JLabel(":" + hiderBad, 0);
            hiderFrownCount.setFont(labelFont);
            c.gridx = -1;
            c.gridy = 0;
            if (hiderGood > 0 || hiderBad > 0) {
                ++c.gridx;
                this.contentPanel.add((Component)hider, c);
            }
            JPanel hiderPanel = new JPanel();
            hiderPanel.setBackground(Color.WHITE);
            hiderPanel.add(hiderSmile);
            hiderPanel.add(hiderSmileCount);
            hiderPanel.add(Box.createHorizontalStrut(20));
            hiderPanel.add(hiderFrown);
            hiderPanel.add(hiderFrownCount);
            c.gridy = 1;
            c.insets = new Insets(0, 50, 0, 50);
            if (hiderGood > 0 || hiderBad > 0) {
                this.contentPanel.add((Component)hiderPanel, c);
            }
            JLabel seeker = new JLabel();
            seeker.setIcon(new ImageIcon(this.pirateImage));
            JLabel seekerSmile = new JLabel();
            seekerSmile.setIcon(new ImageIcon(this.smileImage));
            JLabel seekerSmileCount = new JLabel(":" + seekerGood, 0);
            seekerSmileCount.setFont(labelFont);
            JLabel seekerFrown = new JLabel();
            seekerFrown.setIcon(new ImageIcon(this.frownImage));
            JLabel seekerFrownCount = new JLabel(":" + seekerBad, 0);
            seekerFrownCount.setFont(labelFont);
            c.gridy = 0;
            if (seekerGood > 0 || seekerBad > 0) {
                ++c.gridx;
                this.contentPanel.add((Component)seeker, c);
            }
            JPanel seekerPanel = new JPanel();
            seekerPanel.setBackground(Color.WHITE);
            seekerPanel.add(seekerSmile);
            seekerPanel.add(seekerSmileCount);
            seekerPanel.add(Box.createHorizontalStrut(20));
            seekerPanel.add(seekerFrown);
            seekerPanel.add(seekerFrownCount);
            c.gridy = 1;
            if (seekerGood > 0 || seekerBad > 0) {
                this.contentPanel.add((Component)seekerPanel, c);
            }
        }
        JLabel total = new JLabel(this.parseString(this.totalText), 0);
        total.setFont(labelFont);
        c.gridy = 2;
        c.gridwidth = 0;
        if (seekerGood > 0 || seekerBad > 0) {
            ++c.gridwidth;
        }
        if (hiderGood > 0 || hiderBad > 0) {
            ++c.gridwidth;
        }
        c.gridx = 0;
        c.insets = new Insets(20, 0, 0, 0);
        this.contentPanel.add((Component)total, c);
        final JButton okButton = new JButton(this.parseString(this.okButtonLabel));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                okButton.setEnabled(false);
                HideGUI.this.makeMove();
            }
        });
        ++c.gridy;
        this.contentPanel.add((Component)okButton, c);
        this.validate();
        this.repaint();
    }

    protected void hideNotify(boolean enable) {
        this.hideTime = System.currentTimeMillis() - this.startTime;
        this.hideDone = enable;
        this.checkOkButton();
    }

    protected void hintNotify(boolean enable) {
        this.hintTime = System.currentTimeMillis() - this.startTime;
        this.hintDone = enable;
        this.checkOkButton();
    }

    private void checkOkButton() {
        this.okButton.setEnabled(this.hideDone && (!this.useHideHint || this.hintDone));
        this.repaint();
    }

    protected void seekNotify(boolean enable) {
        this.seekTime = System.currentTimeMillis() - this.startTime;
        this.okButton.setEnabled(enable);
        this.repaint();
    }

    public void processMessage(MessagePacket mes) {
        try {
            if (mes.getType() == 5) {
                Information information = (Information)mes.getObject();
            } else {
                super.processMessage(mes);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to process a game-specific message in the compromise gui" + MSConstants.newline + e));
        }
    }

    public void testingProcedures() {
        int numChoices = 2;
        int move = this.rand.nextInt(numChoices);
        long time = new Long(this.rand.nextInt(5000));
        this.addInfo("move", "" + move);
        this.addInfo("time", "" + time);
    }

    public void respond(Object obj) {
    }

    public void close() {
    }

    public void reauthenticate() {
    }

    protected void constructWaitingLayout(Information info) {
    }
}

