/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.plugins.hide;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.MessageProcessor;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class HideControl
extends ServerControl {
    private float[] positionPayoffs;
    public static Category log = Logger.getLogger(HideControl.class);
    private int HIDE;
    private int SEEK;
    private int accumulatingSize;
    private String hideText;
    private String okButtonLabel;
    private String hideWaitText;
    private String presentImage;
    private String seekText;
    private String seekWaitText;
    private String hideHintText;
    private String youHideText;
    private String pointsText;
    private String otherHideText;
    private String otherPointsText;
    private String totalText;
    private String farmerImage;
    private String pirateImage;
    private String smileImage;
    private String frownImage;
    private boolean showFinalScreen;
    private boolean showTokens;
    private boolean showSummaryFeedback;
    private boolean showAccumulatingFeedback;
    private boolean showSummaryImages;
    private boolean useHideHint;
    private boolean switchRoles;
    private boolean showFacesOnAccumulatingFeedback;

    public void initialize() {
        try {
            String sp = this.getStringProperty("positionPayoffs");
            String[] split = sp.split(",");
            this.positionPayoffs = new float[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.positionPayoffs[i] = Float.parseFloat(split[i].trim());
            }
            this.useHideHint = this.getBooleanProperty("useHideHint", false);
            this.showFinalScreen = this.getBooleanProperty("showFinalScreen", false);
            this.showTokens = this.getBooleanProperty("showTokens", false);
            this.showSummaryFeedback = this.getBooleanProperty("showSummaryFeedback");
            this.showSummaryImages = this.getBooleanProperty("showSummaryImages", true);
            this.showAccumulatingFeedback = this.getBooleanProperty("showAccumulatingFeedback");
            this.showFacesOnAccumulatingFeedback = this.getBooleanProperty("showFacesOnAccumulatingFeedback");
            this.switchRoles = this.getBooleanProperty("switchRoles");
            this.hideText = this.testedStringProperty("gui.hideText");
            this.okButtonLabel = this.testedStringProperty("gui.okButtonLabel");
            this.hideWaitText = this.testedStringProperty("gui.hideWaitText");
            this.presentImage = this.testedStringProperty("presentImage");
            this.seekText = this.testedStringProperty("gui.seekText");
            this.seekWaitText = this.testedStringProperty("gui.seekWaitText");
            this.hideHintText = this.testedStringProperty("gui.hideHintText");
            this.farmerImage = this.testedStringProperty("farmerImage");
            this.pirateImage = this.testedStringProperty("pirateImage");
            this.smileImage = this.testedStringProperty("smileImage");
            this.frownImage = this.testedStringProperty("frownImage");
            this.accumulatingSize = this.getIntProperty("gui.accumulatingSize", 28);
            this.youHideText = this.testedStringProperty("gui.youHideText");
            this.pointsText = this.testedStringProperty("gui.pointsText");
            this.otherHideText = this.testedStringProperty("gui.otherHideText");
            this.otherPointsText = this.testedStringProperty("gui.otherPointsText");
            this.totalText = this.testedStringProperty("gui.totalText");
        }
        catch (Exception e) {
            log.error((Object)("Failed to initialize Army controller" + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    public void runSequence() throws AbortRoundException {
        try {
            int i;
            int i2;
            this.initHistoryTable();
            if (this.getStringProperty("askQuestions") != null && this.getStringProperty("askQuestions").equalsIgnoreCase("true")) {
                Vector[][] questions = this.constructQuestions();
                this.questionSubjectsPostMatch(questions);
            }
            if (experimentData.containsKey("HIDE")) {
                this.HIDE = (Integer)experimentData.get("HIDE");
                this.SEEK = (this.HIDE + 1) % 2;
            } else {
                this.HIDE = 0;
                this.SEEK = 1;
            }
            System.out.println("HIDE from previous repetition is: " + this.HIDE);
            if (this.switchRoles) {
                System.out.println(".... switching roles...");
                this.HIDE = (this.HIDE + 1) % 2;
                this.SEEK = (this.HIDE + 1) % 2;
            }
            System.out.println("hide=" + this.HIDE + ", seek=" + this.SEEK);
            Information[] info = new Information[groupSize];
            for (i2 = 0; i2 < info.length; ++i2) {
                info[i2] = new Information();
                info[i2].addIntInfo((Object)"index", i2);
                info[i2].addInfo((Object)"positionPayoffs", (Object)this.positionPayoffs);
                info[i2].addStringInfo((Object)"presentImage", this.presentImage);
                info[i2].addBooleanInfo((Object)"useHideHint", this.useHideHint);
                info[i2].addBooleanInfo((Object)"showTokens", this.showTokens);
                info[i2].addStringInfo((Object)"smileImage", this.smileImage);
                info[i2].addStringInfo((Object)"frownImage", this.frownImage);
                info[i2].addBooleanInfo((Object)"showAccumulatingFeedback", this.showAccumulatingFeedback);
                info[i2].addBooleanInfo((Object)"showFacesOnAccumulatingFeedback", this.showFacesOnAccumulatingFeedback);
            }
            if (this.showAccumulatingFeedback) {
                for (i2 = 0; i2 < groupSize; ++i2) {
                    if (!experimentData.containsKey("hiderData.player." + this.clientData[i2].getId())) {
                        experimentData.put("hiderData.player." + this.clientData[i2].getId(), new ArrayList());
                    }
                    if (!experimentData.containsKey("hiderPositions.player." + this.clientData[i2].getId())) {
                        experimentData.put("hiderPositions.player." + this.clientData[i2].getId(), new ArrayList());
                    }
                    if (!experimentData.containsKey("hiderPays.player." + this.clientData[i2].getId())) {
                        experimentData.put("hiderPays.player." + this.clientData[i2].getId(), new ArrayList());
                    }
                    if (!experimentData.containsKey("seekerData.player." + this.clientData[i2].getId())) {
                        experimentData.put("seekerData.player." + this.clientData[i2].getId(), new ArrayList());
                    }
                    if (!experimentData.containsKey("seekerPositions.player." + this.clientData[i2].getId())) {
                        experimentData.put("seekerPositions.player." + this.clientData[i2].getId(), new ArrayList());
                    }
                    if (experimentData.containsKey("seekerPays.player." + this.clientData[i2].getId())) continue;
                    experimentData.put("seekerPays.player." + this.clientData[i2].getId(), new ArrayList());
                }
                ArrayList accumulatingHiderData = (ArrayList)experimentData.get("hiderData.player." + this.clientData[this.HIDE].getId());
                ArrayList accumulatingSeekerData = (ArrayList)experimentData.get("seekerData.player." + this.clientData[this.SEEK].getId());
                ArrayList accumulatingHiderPositions = (ArrayList)experimentData.get("hiderPositions.player." + this.clientData[this.HIDE].getId());
                ArrayList accumulatingSeekerPositions = (ArrayList)experimentData.get("seekerPositions.player." + this.clientData[this.HIDE].getId());
                info[this.HIDE].addInfo((Object)"accumulatingData", (Object)accumulatingHiderData);
                info[this.HIDE].addInfo((Object)"accumulatingPositions", (Object)accumulatingHiderPositions);
                info[this.SEEK].addInfo((Object)"accumulatingData", (Object)accumulatingSeekerData);
                info[this.SEEK].addInfo((Object)"accumulatingPositions", (Object)accumulatingSeekerPositions);
            }
            info[this.HIDE].addStringInfo((Object)"accumulatingImage", this.farmerImage);
            info[this.HIDE].addIntInfo((Object)"accumulatingSize", this.accumulatingSize);
            info[this.SEEK].addStringInfo((Object)"accumulatingImage", this.pirateImage);
            info[this.HIDE].addStringInfo((Object)"type", "hide");
            info[this.HIDE].addStringInfo((Object)"hideText", this.hideText);
            info[this.HIDE].addStringInfo((Object)"okButtonLabel", this.okButtonLabel);
            info[this.HIDE].addStringInfo((Object)"hideHintText", this.hideHintText);
            info[this.HIDE].addStringInfo((Object)"farmerImage", this.farmerImage);
            info[this.SEEK].addStringInfo((Object)"type", "hideWait");
            info[this.SEEK].addStringInfo((Object)"hideWaitText", this.hideWaitText);
            Information[] results = this.askAllPlayers(info);
            if (this.groupNumber == 0) {
                experimentData.put("HIDE", new Integer(this.HIDE));
            }
            int hidePosition = results[this.HIDE].getIntInfo((Object)"hidingSpot");
            String hideTime = results[this.HIDE].getStringInfo((Object)"hideTime");
            int hideHint = -1;
            String hintTime = "N/A";
            if (this.useHideHint) {
                hideHint = results[this.HIDE].getIntInfo((Object)"hintSpot");
                System.out.println("result retrieved for hintSpot=" + results[this.HIDE].getInfo((Object)"hintSpot"));
                hintTime = results[this.HIDE].getStringInfo((Object)"hintTime");
            }
            System.out.println("HIDING player hid the present in spot: " + hidePosition + " (in " + hideTime + " milliseconds)");
            Information[] sInfo = new Information[groupSize];
            for (int i3 = 0; i3 < sInfo.length; ++i3) {
                sInfo[i3] = new Information();
                sInfo[i3].addIntInfo((Object)"hidePosition", hidePosition);
                sInfo[i3].addInfo((Object)"positionPayoffs", (Object)this.positionPayoffs);
                sInfo[i3].addStringInfo((Object)"presentImage", this.presentImage);
                sInfo[i3].addBooleanInfo((Object)"showTokens", this.showTokens);
                sInfo[i3].addStringInfo((Object)"smileImage", this.smileImage);
                sInfo[i3].addStringInfo((Object)"frownImage", this.frownImage);
                sInfo[i3].addBooleanInfo((Object)"showAccumulatingFeedback", this.showAccumulatingFeedback);
                sInfo[i3].addBooleanInfo((Object)"showFacesOnAccumulatingFeedback", this.showFacesOnAccumulatingFeedback);
            }
            sInfo[this.HIDE].addStringInfo((Object)"type", "seekWait");
            sInfo[this.HIDE].addStringInfo((Object)"seekWaitText", this.seekWaitText);
            if (this.useHideHint) {
                sInfo[this.SEEK].addIntInfo((Object)"hideHint", hideHint);
            } else {
                sInfo[this.SEEK].addIntInfo((Object)"hideHint", -1);
            }
            if (this.showAccumulatingFeedback) {
                ArrayList accumulatingSeekerData = (ArrayList)experimentData.get("seekerData.player." + this.clientData[this.SEEK].getId());
                sInfo[this.SEEK].addInfo((Object)"accumulatingData", (Object)accumulatingSeekerData);
                ArrayList accumulatingSeekerPositions = (ArrayList)experimentData.get("seekerPositions.player." + this.clientData[this.SEEK].getId());
                sInfo[this.SEEK].addInfo((Object)"accumulatingPositions", (Object)accumulatingSeekerPositions);
                sInfo[this.SEEK].addStringInfo((Object)"accumulatingImage", this.pirateImage);
            }
            sInfo[this.SEEK].addStringInfo((Object)"type", "seek");
            sInfo[this.SEEK].addStringInfo((Object)"seekText", this.seekText);
            sInfo[this.SEEK].addStringInfo((Object)"okButtonLabel", this.okButtonLabel);
            sInfo[this.SEEK].addStringInfo((Object)"pirateImage", this.pirateImage);
            sInfo[this.HIDE].addStringInfo((Object)"accumulatingImage", this.farmerImage);
            sInfo[this.SEEK].addStringInfo((Object)"accumulatingImage", this.pirateImage);
            sInfo[this.SEEK].addIntInfo((Object)"accumulatingSize", this.accumulatingSize);
            Information[] seekResults = this.askAllPlayers(sInfo);
            int seekSpot = seekResults[this.SEEK].getIntInfo((Object)"seekSpot");
            String seekTime = seekResults[this.SEEK].getStringInfo((Object)"seekTime");
            System.out.println("SEEKing player guessed spot " + seekSpot + " (in time " + seekTime + " milliseconds)");
            float[] payoffs = new float[groupSize];
            if (hidePosition == seekSpot) {
                payoffs[this.HIDE] = 0.0f;
                payoffs[this.SEEK] = this.positionPayoffs[hidePosition];
            } else {
                payoffs[this.HIDE] = this.positionPayoffs[hidePosition];
                payoffs[this.SEEK] = 0.0f;
            }
            this.addPayoffs(payoffs);
            for (int i4 = 0; i4 < groupSize; ++i4) {
                this.addOutput(i4, "subjectName", this.clientData[i4].getName());
                this.addOutput(i4, "payoffVector", "\"" + this.getStringProperty("positionPayoffs") + "\"");
            }
            this.addOutput(this.HIDE, "hidePosition", String.valueOf(hidePosition));
            this.addOutput(this.HIDE, "hideTime", hideTime);
            if (this.useHideHint) {
                this.addOutput(this.HIDE, "hintPosition", String.valueOf(hideHint));
                this.addOutput(this.HIDE, "hintTime", hintTime);
            }
            this.addOutput(this.SEEK, "seekSpot", String.valueOf(seekSpot));
            this.addOutput(this.SEEK, "seekTime", seekTime);
            ArrayList hiderData = null;
            hiderData = !experimentData.containsKey("hiderData.player." + this.clientData[this.HIDE].getId()) ? new ArrayList() : (ArrayList)experimentData.get("hiderData.player." + this.clientData[this.HIDE].getId());
            hiderData.add("" + hidePosition + "," + seekSpot);
            experimentData.put("hiderData.player." + this.clientData[this.HIDE].getId(), hiderData);
            ArrayList hiderPositions = null;
            hiderPositions = !experimentData.containsKey("hiderPositions.player." + this.clientData[this.HIDE].getId()) ? new ArrayList() : (ArrayList)experimentData.get("hiderPositions.player." + this.clientData[this.HIDE].getId());
            hiderPositions.add(this.positionPayoffs);
            experimentData.put("hiderPositions.player." + this.clientData[this.HIDE].getId(), hiderPositions);
            ArrayList hiderPays = null;
            hiderPays = !experimentData.containsKey("hiderPays.player." + this.clientData[this.HIDE].getId()) ? new ArrayList() : (ArrayList)experimentData.get("hiderPays.player." + this.clientData[this.HIDE].getId());
            hiderPays.add(Float.valueOf(payoffs[this.HIDE]));
            experimentData.put("hiderPays.player." + this.clientData[this.HIDE].getId(), hiderPays);
            ArrayList seekerData = null;
            seekerData = !experimentData.containsKey("seekerData.player." + this.clientData[this.SEEK].getId()) ? new ArrayList() : (ArrayList)experimentData.get("seekerData.player." + this.clientData[this.SEEK].getId());
            seekerData.add("" + hidePosition + "," + seekSpot);
            experimentData.put("seekerData.player." + this.clientData[this.SEEK].getId(), seekerData);
            ArrayList seekerPositions = null;
            seekerPositions = !experimentData.containsKey("seekerPositions.player." + this.clientData[this.SEEK].getId()) ? new ArrayList() : (ArrayList)experimentData.get("seekerPositions.player." + this.clientData[this.SEEK].getId());
            seekerPositions.add(this.positionPayoffs);
            experimentData.put("seekerPositions.player." + this.clientData[this.SEEK].getId(), seekerPositions);
            ArrayList seekerPays = null;
            seekerPays = !experimentData.containsKey("seekerPays.player." + this.clientData[this.SEEK].getId()) ? new ArrayList() : (ArrayList)experimentData.get("seekerPays.player." + this.clientData[this.SEEK].getId());
            System.out.println("adding new seeker payment (current seekerPays size is: " + seekerPays.size() + ") for player id" + this.clientData[this.SEEK].getId());
            seekerPays.add(Float.valueOf(payoffs[this.SEEK]));
            experimentData.put("seekerPays.player." + this.clientData[this.SEEK].getId(), seekerPays);
            DecimalFormat df = new DecimalFormat("0");
            Information[] sum = new Information[groupSize];
            for (i = 0; i < groupSize; ++i) {
                ArrayList hp;
                sum[i] = new Information();
                sum[i].addStringInfo((Object)"youHideText", this.youHideText);
                sum[i].addStringInfo((Object)"pointsText", this.pointsText);
                sum[i].addStringInfo((Object)"otherHideText", this.otherHideText);
                sum[i].addStringInfo((Object)"otherPointsText", this.otherPointsText);
                sum[i].addStringInfo((Object)"totalText", this.totalText);
                sum[i].addStringInfo((Object)"farmerImage", this.farmerImage);
                sum[i].addStringInfo((Object)"pirateImage", this.pirateImage);
                sum[i].addStringInfo((Object)"smileImage", this.smileImage);
                sum[i].addStringInfo((Object)"frownImage", this.frownImage);
                if (experimentData.containsKey("hiderData.player." + this.clientData[i].getId())) {
                    sum[i].addInfo((Object)"hiderData", experimentData.get("hiderData.player." + this.clientData[i].getId()));
                } else {
                    sum[i].addInfo((Object)"hiderData", new ArrayList());
                }
                if (experimentData.containsKey("hiderPositions.player." + this.clientData[i].getId())) {
                    sum[i].addInfo((Object)"hiderPositions", experimentData.get("hiderPositions.player." + this.clientData[i].getId()));
                } else {
                    sum[i].addInfo((Object)"hiderPositions", new ArrayList());
                }
                if (experimentData.containsKey("hiderPays.player." + this.clientData[i].getId())) {
                    sum[i].addInfo((Object)"hiderPays", experimentData.get("hiderPays.player." + this.clientData[i].getId()));
                } else {
                    sum[i].addInfo((Object)"hiderPays", new ArrayList());
                }
                if (experimentData.containsKey("seekerData.player." + this.clientData[i].getId())) {
                    sum[i].addInfo((Object)"seekerData", experimentData.get("seekerData.player." + this.clientData[i].getId()));
                } else {
                    sum[i].addInfo((Object)"seekerData", new ArrayList());
                }
                if (experimentData.containsKey("seekerPositions.player." + this.clientData[i].getId())) {
                    sum[i].addInfo((Object)"seekerPositions", experimentData.get("seekerPositions.player." + this.clientData[i].getId()));
                } else {
                    sum[i].addInfo((Object)"seekerPositions", new ArrayList());
                }
                if (experimentData.containsKey("seekerPays.player." + this.clientData[i].getId())) {
                    sum[i].addInfo((Object)"seekerPays", experimentData.get("seekerPays.player." + this.clientData[i].getId()));
                } else {
                    sum[i].addInfo((Object)"seekerPays", new ArrayList());
                }
                float totalPay = 0.0f;
                ArrayList sp = (ArrayList)experimentData.get("seekerPays.player." + this.clientData[i].getId());
                if (sp != null) {
                    Iterator iterator = sp.iterator();
                    while (iterator.hasNext()) {
                        float f = ((Float)iterator.next()).floatValue();
                        totalPay += f;
                    }
                }
                if ((hp = (ArrayList)experimentData.get("hiderPays.player." + this.clientData[i].getId())) != null) {
                    Iterator iterator = hp.iterator();
                    while (iterator.hasNext()) {
                        float f = ((Float)iterator.next()).floatValue();
                        totalPay += f;
                    }
                }
                sum[i].addStringInfo((Object)"totalPay", df.format(totalPay));
            }
            if (this.showSummaryFeedback && this.isLastRound()) {
                for (i = 0; i < groupSize; ++i) {
                    sum[i].addStringInfo((Object)"type", "summary");
                    sum[i].addBooleanInfo((Object)"showSummaryImages", this.showSummaryImages);
                }
                this.askAllPlayers(sum);
            }
            if (this.showSummaryFeedback) {
                for (i = 0; i < groupSize; ++i) {
                    experimentData.put("hiderData.player." + this.clientData[i].getId(), new ArrayList());
                    experimentData.put("hiderPositions.player." + this.clientData[i].getId(), new ArrayList());
                    experimentData.put("hiderPays.player." + this.clientData[i].getId(), new ArrayList());
                    experimentData.put("seekerData.player." + this.clientData[i].getId(), new ArrayList());
                    experimentData.put("seekerPositions.player." + this.clientData[i].getId(), new ArrayList());
                    experimentData.put("seekerPays.player." + this.clientData[i].getId(), new ArrayList());
                }
            }
        }
        catch (AbortRoundException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)("Failed to run the Hide main game sequence" + newline + e));
            e.printStackTrace();
            throw new AbortRoundException();
        }
    }

    private void initHistoryTable() {
        for (int i = 0; i < groupSize; ++i) {
        }
    }

    protected Information[] processRound(MessageProcessor proc) throws AbortRoundException {
        return null;
    }

    private String testedStringProperty(String keyword) {
        String defaultVal = "#$%UNCOMMON DEFAULT VALUE!%$#";
        String val = this.getStringProperty(keyword, "#$%UNCOMMON DEFAULT VALUE!%$#");
        if (val.equalsIgnoreCase("#$%UNCOMMON DEFAULT VALUE!%$#")) {
            log.error((Object)(keyword + "incorrectly read from properties file.  Using default value '" + keyword + "'"));
            System.out.println(keyword + "incorrectly read from properties file.  Using default value '" + keyword + "'");
            val = keyword;
        }
        return val;
    }
}

