/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.plugins.hide;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedbackPanel
extends JPanel {
    private Color hideColor = Color.YELLOW;
    private Color seekColor = Color.BLUE;
    private Color bothColor = Color.GREEN;
    private ArrayList<float[]> payoffPositions;
    private ArrayList<Integer> hidePositions;
    private ArrayList<Integer> seekPositions;
    private ArrayList<Float> points;
    private DecimalFormat df = new DecimalFormat("0.00");
    private Font labelFont = new Font("Arial", 1, 24);
    private String hideText;
    private String pointsText;

    public FeedbackPanel(ArrayList<Integer> hides, ArrayList<Integer> seeks, ArrayList<float[]> positions, ArrayList<Float> pays, String hide, String pText) {
        this.hidePositions = new ArrayList();
        this.hidePositions.addAll(hides);
        this.seekPositions = new ArrayList();
        this.seekPositions.addAll(seeks);
        this.payoffPositions = new ArrayList();
        this.payoffPositions.addAll(positions);
        this.points = new ArrayList();
        this.points.addAll(pays);
        this.hideText = hide;
        this.pointsText = pText;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JLabel youHide = new JLabel(this.hideText, 0);
        youHide.setFont(this.labelFont);
        JLabel pointsLabel = new JLabel(this.pointsText, 0);
        pointsLabel.setFont(this.labelFont);
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(10, 10, 0, 10);
        this.add((Component)youHide, c);
        c.gridx = 1;
        this.add((Component)pointsLabel, c);
        DecimalFormat df = new DecimalFormat("0.00");
        if (this.hidePositions.size() == 0) {
            float[] x = new float[3];
            for (int i = 0; i < x.length; ++i) {
                x[i] = 1.0f;
            }
            FeedbackEntry blank = new FeedbackEntry(x, -1, -1);
            blank.setBlank(true);
            c.gridy = 1;
            c.gridx = 0;
            this.add((Component)blank, c);
        } else {
            for (int i = 0; i < this.hidePositions.size(); ++i) {
                FeedbackEntry fe = new FeedbackEntry(this.payoffPositions.get(i), this.hidePositions.get(i), this.seekPositions.get(i));
                c.gridy = i + 1;
                c.gridx = 0;
                this.add((Component)fe, c);
                JLabel pay = new JLabel(df.format(this.points.get(i)), 0);
                pay.setFont(this.labelFont);
                c.gridx = 1;
                this.add((Component)pay, c);
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<float[]> pays = new ArrayList<float[]>();
        ArrayList<Integer> h = new ArrayList<Integer>();
        ArrayList<Integer> s = new ArrayList<Integer>();
        h.add(4);
        s.add(7);
        float[] x = new float[]{-1.0f, -1.0f, 2.0f, -1.0f, 3.0f, -1.0f, 5.0f, 5.0f, -1.0f};
        pays.add(x);
        h.add(2);
        s.add(2);
        float[] y = new float[]{-1.0f, -1.0f, 2.0f, -1.0f, 3.0f, -1.0f, 5.0f, 5.0f, -1.0f};
        pays.add(y);
        ArrayList<Float> payoffs = new ArrayList<Float>();
        payoffs.add(Float.valueOf(5.0f));
        payoffs.add(Float.valueOf(6.0f));
        FeedbackPanel fp = new FeedbackPanel(h, s, pays, payoffs, "You Hide", "Points");
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(new Dimension(800, 800));
        frame.add(fp);
        frame.setVisible(true);
    }

    protected class FeedbackEntry
    extends JPanel {
        private float[] payoffPositions;
        private int hidePosition;
        private int seekPosition;
        private boolean blank;
        private JLabel[] positionLabels;

        public FeedbackEntry(float[] positions, int hide, int seek) {
            this.payoffPositions = new float[positions.length];
            for (int i = 0; i < positions.length; ++i) {
                this.payoffPositions[i] = positions[i];
            }
            this.hidePosition = hide;
            this.seekPosition = seek;
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            int xpos = 0;
            this.positionLabels = new JLabel[this.payoffPositions.length];
            for (int i = 0; i < this.payoffPositions.length; ++i) {
                System.out.println("i==" + i + ", hidePosition=" + this.hidePosition + ", seekPosition=" + this.seekPosition);
                if (!(this.payoffPositions[i] > 0.0f)) continue;
                JPanel entryPanel = new JPanel();
                entryPanel.setLayout(new GridBagLayout());
                GridBagConstraints epc = new GridBagConstraints();
                this.positionLabels[i] = new JLabel(FeedbackPanel.this.df.format(this.payoffPositions[i]), 0);
                this.positionLabels[i].setFont(FeedbackPanel.this.labelFont);
                if (i == this.hidePosition) {
                    System.out.println("HIDE");
                    this.positionLabels[i].setBackground(FeedbackPanel.this.hideColor);
                    this.positionLabels[i].setOpaque(true);
                }
                if (i == this.seekPosition) {
                    System.out.println("SEEK");
                    entryPanel.setBackground(FeedbackPanel.this.seekColor);
                }
                entryPanel.add((Component)this.positionLabels[i], epc);
                c.gridx = xpos++;
                c.ipadx = 20;
                c.ipady = 20;
                c.insets = new Insets(20, 20, 20, 20);
                this.add((Component)entryPanel, c);
            }
        }

        public void setBlank(boolean blank) {
            this.blank = blank;
            for (int i = 0; this.positionLabels != null && i < this.positionLabels.length; ++i) {
                if (this.positionLabels[i] == null) continue;
                this.positionLabels[i].setForeground(this.positionLabels[i].getBackground());
            }
            this.repaint();
        }
    }
}

