/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.plugins.hide;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AccumulatingEntry
extends JPanel {
    private boolean faces;
    private String image;
    private String value;
    private JLabel imageLabel;

    public AccumulatingEntry(String outcomeImage, String entryValue, int size) {
        this.image = outcomeImage;
        this.value = entryValue;
        this.setBackground(Color.WHITE);
        CircleLabel cl = new CircleLabel(this.value, size);
        this.imageLabel = new JLabel();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.imageLabel.setIcon(new ImageIcon(new ImageIcon(this.image).getImage().getScaledInstance(screen.height / 24, screen.height / 24, 4)));
        this.add(cl);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.imageLabel);
        this.validate();
        this.repaint();
    }

    public void showFaces(boolean sf) {
        this.faces = sf;
        if (!this.faces) {
            this.remove(this.imageLabel);
            this.validate();
            this.repaint();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(new Dimension(1366, 768));
        String smile = "c:\\smile.JPG";
        String frown = "c:\\frown.JPG";
        AccumulatingEntry entry = new AccumulatingEntry(smile, "5", 20);
        entry.setBorder(BorderFactory.createLineBorder(Color.RED, 3));
        frame.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        frame.add((Component)entry, c);
        frame.setVisible(true);
    }

    protected class CircleLabel
    extends JLabel {
        private String circleValue;
        private int fontSize = 28;

        public CircleLabel(String s, int size) {
            this.circleValue = s;
            this.fontSize = size;
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.setPreferredSize(new Dimension(screen.height / 24, screen.height / 24));
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            Dimension size = this.getSize();
            g2.setStroke(new BasicStroke(4.0f));
            g2.drawOval(5, 5, size.width - 10, size.width - 10);
            g2.setFont(g2.getFont().deriveFont(0.0f + (float)this.fontSize));
            FontMetrics fm = g2.getFontMetrics();
            g2.drawString(this.circleValue, size.width / 2 - fm.stringWidth(this.circleValue) / 2, size.width / 2 - fm.getHeight() / 2 + fm.getAscent());
        }
    }
}

