* This file replicates Tables 3-11 and D1-D4 of "Economic Uncertainty and Structural Reforms: Evidence from Stock Market Volatility" (A. Bonfiglioli, R. Crinò and G. Gancia)
* Input files: Main-Dataset.dta; 
*			   Democracy-and-Volatility.dta.

clear
clear mata
clear matrix
set more off
cap set mem 5g
set matsize 5000
set maxvar 20000
scalar drop _all
matrix drop _all
macro drop _all

**************************
* Defining global macros *
**************************

global dv			"dlib"

global ev 			"l.vol"
global iv 			"l.wgt_vol_linv_distcap"
global ldv			"l.lib"
global ecfcontr 	"l.ret l.dpricesgdp l.recession l.crisis_b l.crisis_c l.crisis_s l.Dpast3_recession l.Dpast3_crisis_b l.Dpast3_crisis_c l.Dpast3_crisis_s"
global polcontr 	"l.polity2_norm l.pres l.left l.election"
global devcontr 	"l.lrgdppc f2.eu_member l.oecd_member"
global globshk		"l.wgt_dlib_linv_distcap l.wgt_lrgdppc_linv_distcap l.wgt_dpricesgdp_linv_distcap l.wgt_lrate_linv_distcap"

global ecfcontrgr	"l.ret l.dpricesgdp l.dlrgdppc l.crisis_b l.crisis_c l.crisis_s l.Dpast3_recession l.Dpast3_crisis_b l.Dpast3_crisis_c l.Dpast3_crisis_s"

global ev3 			"l3.vol"
global iv3 			"l3.wgt_vol_linv_distcap"
global ldv3			"l3.lib"
global ecfcontr3 	"l3.ret l3.dpricesgdp l3.recession l3.crisis_b l3.crisis_c l3.crisis_s l3.Dpast3_recession l3.Dpast3_crisis_b l3.Dpast3_crisis_c l3.Dpast3_crisis_s"
global polcontr3 	"l3.polity2_norm l3.pres l3.left l3.election"
global devcontr3 	"l3.lrgdppc f2.eu_member l3.oecd_member"
global globshk3		"l3.wgt_dlib_linv_distcap l3.wgt_lrgdppc_linv_distcap l3.wgt_dpricesgdp_linv_distcap l3.wgt_lrate_linv_distcap"

global ev5 			"l5.vol"
global iv5 			"l5.wgt_vol_linv_distcap"
global ldv5			"l5.lib"
global ecfcontr5 	"l5.ret l5.dpricesgdp l5.recession l5.crisis_b l5.crisis_c l5.crisis_s l5.Dpast3_recession l5.Dpast3_crisis_b l5.Dpast3_crisis_c l5.Dpast3_crisis_s"
global polcontr5 	"l5.polity2_norm l5.pres l5.left l5.election"
global devcontr5 	"l5.lrgdppc f2.eu_member l5.oecd_member"
global globshk5		"l5.wgt_dlib_linv_distcap l5.wgt_lrgdppc_linv_distcap l5.wgt_dpricesgdp_linv_distcap l5.wgt_lrate_linv_distcap"

global ev_ 			"l_vol"
global iv_ 			"l_wgt_vol_linv_distcap"
global ldv_			"l_lib"
global ecfcontr_ 	"l_ret l_dpricesgdp l_recession l_crisis_b l_crisis_c l_crisis_s l_Dpast3_recession l_Dpast3_crisis_b l_Dpast3_crisis_c l_Dpast3_crisis_s"
global polcontr_ 	"l_polity2_norm l_pres l_left l_election"
global devcontr_ 	"l_lrgdppc f2_eu_member l_oecd_member"
global globshk_		"l_wgt_dlib_linv_distcap l_wgt_lrgdppc_linv_distcap l_wgt_dpricesgdp_linv_distcap l_wgt_lrate_linv_distcap"

global csfe			"cty_sct"
global yfe			"year"
global syfe			"sct_yr"
global ayfe			"geoarea_yr"
global asyfe		"geoarea_sct_yr"
global ctrnd		"C*_year"
global imfyfe		"imf_group_aggr_yr"
global oecdyfe		"oecd_group_yr"

global cluster		"cty_n"

***************************
* Running the regressions *
***************************

use Main-Dataset.dta,clear

tsset cty_sct year

*======================*
* Table 3 and Table D1 *
*======================*

* Column 1

reghdfe ${dv} ${ev},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

* Column 2

reghdfe ${dv} ${ev} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

* Column 3

reghdfe ${dv} ${ev} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

* Column 4

reghdfe ${dv} ${ev} ${ecfcontr} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

* Column 5

reghdfe ${dv} ${ev} ${ecfcontr} ${devcontr} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

* Column 6

reghdfe ${dv} ${ev} ${ecfcontr} ${devcontr} ${polcontr} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

* Column 7

reghdfe ${dv} ${ev} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

*======================*
* Table 4 and Table D2 *
*======================*

* Column 1

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

gen sampcontr=1 if e(sample)

reghdfe ${ev} ${iv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} if sampcontr==1, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

* Column 2

reghdfe ${dv} ${iv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} if sampcontr==1, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

* Column 3

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

*=========*
* Table 5 *
*=========*

* Column 1

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=l.wgt_vol_linv_distcap_lsmk), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 2

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=l.wgt_vol_linv_distcap_lngdp), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 3

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=l.wgt_vol_linv_distcap_msmk), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 4

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=l.wgt_vol_linv_distcap_mcont), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

*=========*
* Table 6 *
*=========*

* Column 1

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=l.wgt_vol_pltrade), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 2

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=l.wgt_vol_pltrade_lsmk), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 3

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=l.wgt_vol_pltrade_lngdp), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 4

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=l.wgt_vol_pltrade_msmk), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 5

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=l.wgt_vol_pltrade_mcont), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

*=========*
* Table 7 *
*=========*

* Column 1

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if countrycode!="USA", ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 2

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if lctysmk==0, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 3

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if lctygdp==0, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 4

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if cee==0, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 5

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) ///
		if countrycode!="BGD"&countrycode!="EGY"&countrycode!="HTI"&countrycode!="IND"&countrycode!="IDN"& ///
		countrycode!="KEN"&countrycode!="MAR"&countrycode!="NGA"&countrycode!="PAK"&countrycode!="TUN"& ///
		countrycode!="UKR"&countrycode!="VNM", ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 6

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if imf_group=="advanced", ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 7

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if imf_group=="emerging"|imf_group=="low-income", ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 8

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if oecd_member==1, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 9
			  
reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if oecd_member==0, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

*=========*
* Table 8 *
*=========*

* Column 1

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (l.vol_nomax=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 2

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (l.vol_max=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing
		
* Column 3

preserve

bysort ref_num:egen ${dv}_p50=xtile(${dv}),p(50)

replace ${dv}_p50=${dv}_p50-1

tsset cty_sct year

reghdfe ${dv}_p50 ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing
		
* Column 4

bysort ref_num:egen ${dv}_p75=xtile(${dv}),p(75)

replace ${dv}_p75=${dv}_p75-1

tsset cty_sct year

reghdfe ${dv}_p75 ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing
		
restore
			  
*=========*
* Table 9 *
*=========*

preserve

bysort countrycode:egen vol_f_yr=first(year) if vol!=.

bysort countrycode:egen vol_l_yr=lastnm(year) if vol!=.

tsset cty_sct year

* Column 1

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if vol_f_yr<=1973&vol_l_yr==2006&year>=1973, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 2

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if vol_f_yr<=1983&vol_l_yr==2006&year>=1983, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 3

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if vol_f_yr<=1989&vol_l_yr==2006&year>=1989, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing
	
* Column 4

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) ///
		if dlib_tr!=.&dlib_cur!=.&dlib_nw!=.&dlib_ag!=.&dlib_df!=.&dlib_cap!=., ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing
 
* Column 5

tsset cty_sct year

gen dlib3=lib-l3.lib

reghdfe dlib3 ${ecfcontr3} ${devcontr3} ${polcontr3} ${globshk3} ${ldv3} ${ctrnd} (${ev3}=${iv3}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 6

tsset cty_sct year

gen dlib5=lib-l5.lib

reghdfe dlib5 ${ecfcontr5} ${devcontr5} ${polcontr5} ${globshk5} ${ldv5} ${ctrnd} (${ev5}=${iv5}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 7

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if ref_num==1|ref_num==2, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 8
			  
reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if ref_num==3|ref_num==4, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 9
			  
reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if ref_num==5|ref_num==6, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

restore

*==========*
* Table 10 *
*==========*

preserve

tab year,gen(Y)

* Column 1

bysort countrycode:egen lib_avg_f=first(lib_avg)

bysort countrycode:egen lib_avg_l=lastnm(lib_avg)

gen ov_dlib_avg=lib_avg_l-lib_avg_f

xtile bin_ov_dlib_avg=ov_dlib_avg,n(5)

tab bin_ov_dlib_avg,gen(BIN)

distinct year

forvalues y=1/5 {

	forvalues x=1/`r(ndistinct)' {

		gen BIN`y'_Y`x'=BIN`y'*Y`x'

	}
	
}

tsset cty_sct year

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} BIN*_Y* (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

drop BIN*			  
		  
* Column 2

bysort countrycode:egen lrgdppc_f=first(lrgdppc)

bysort countrycode:egen lrgdppc_l=lastnm(lrgdppc)

gen ov_dlrgdppc=lrgdppc_l-lrgdppc_f

xtile bin_ov_dlrgdppc=ov_dlrgdppc,n(5)

tab bin_ov_dlrgdppc,gen(BIN)

distinct year

forvalues y=1/5 {

	forvalues x=1/`r(ndistinct)' {

		gen BIN`y'_Y`x'=BIN`y'*Y`x'

	}
	
}

tsset cty_sct year

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} BIN*_Y* (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

drop BIN*			  
		  
* Column 3

bysort countrycode:egen dpricesgdp_f=first(dpricesgdp)

bysort countrycode:egen dpricesgdp_l=lastnm(dpricesgdp)

gen ov_dinfl=dpricesgdp_l-dpricesgdp_f

xtile bin_ov_dinfl=ov_dinfl,n(5)

tab bin_ov_dinfl,gen(BIN)

distinct year

forvalues y=1/5 {

	forvalues x=1/`r(ndistinct)' {

		gen BIN`y'_Y`x'=BIN`y'*Y`x'

	}
	
}

tsset cty_sct year

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} BIN*_Y* (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

drop BIN*			  
		  
* Column 4

bysort countrycode:egen polity2_norm_f=first(polity2_norm)

bysort countrycode:egen polity2_norm_l=lastnm(polity2_norm)

gen ov_dpolity2_t=polity2_norm_l-polity2_norm_f

bysort countrycode:egen ov_dpolity2=mean(ov_dpolity2_t)

drop ov_dpolity2_t

xtile bin_ov_dpolity2=ov_dpolity2,n(5)

tab bin_ov_dpolity2,gen(BIN)

distinct year

forvalues y=1/4 {

	forvalues x=1/`r(ndistinct)' {

		gen BIN`y'_Y`x'=BIN`y'*Y`x'

	}
	
}

tsset cty_sct year

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} BIN*_Y* (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

drop BIN*			  

* Column 5

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe} ${ayfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

restore

*==========*
* Table 11 *
*==========*

preserve

tab year,gen(Y)

* Column 1

bysort countrycode:egen dlib_avg_ct_f=first(dlib_avg_ct)

distinct year

forvalues x=1/`r(ndistinct)' {

	gen dlib_avg_ct_f_Y`x'=dlib_avg_ct_f*Y`x'

}

tsset cty_sct year

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} dlib_avg_ct_f_Y* (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 2

bysort countrycode:egen lrgdppc_f=first(lrgdppc)

distinct year

forvalues x=1/`r(ndistinct)' {

	gen lrgdppc_f_Y`x'=lrgdppc_f*Y`x'

}

tsset cty_sct year

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} lrgdppc_f_Y* (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 3

bysort countrycode:egen dpricesgdp_f=first(dpricesgdp)

distinct year

forvalues x=1/`r(ndistinct)' {

	gen dpricesgdp_f_Y`x'=dpricesgdp_f*Y`x'

}

tsset cty_sct year

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} dpricesgdp_f_Y* (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 4

bysort countrycode:egen polity2_norm_f_t=first(polity2_norm)

bysort countrycode:egen polity2_norm_f=mean(polity2_norm_f_t)

drop polity2_norm_f_t

distinct year

forvalues x=1/`r(ndistinct)' {

	gen polity2_norm_f_Y`x'=polity2_norm_f*Y`x'

}

tsset cty_sct year

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} polity2_norm_f_Y* (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 5

bysort countrycode:egen left_f=first(left)

distinct year

forvalues x=1/`r(ndistinct)' {

	gen left_f_Y`x'=left_f*Y`x'

}

tsset cty_sct year

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} left_f_Y* (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 6

bysort countrycode:egen oecd_member_f=first(oecd_member)

distinct year

forvalues x=1/`r(ndistinct)' {

	gen oecd_member_f_Y`x'=oecd_member_f*Y`x'

}

tsset cty_sct year

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} oecd_member_f_Y* (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 7

tab imf_group_aggr,gen(IMF)

bysort countrycode:egen imf_f=first(IMF1)

distinct year

forvalues x=1/`r(ndistinct)' {

	gen imf_f_Y`x'=imf_f*Y`x'

}

tsset cty_sct year

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} imf_f_Y* (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 8

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (f.vol=f.wgt_vol_linv_distcap), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

restore

*==========*
* Table D3 *
*==========*

* Column 1

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 2

reghdfe ${dv} ${ecfcontrgr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 3

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} l.imf_sba5 l.imf_saf5 l.imf_eff5 (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 4

preserve

tsset cty_sct year

gen dlib3=lib-l3.lib
			  
reghdfe dlib3 ${ecfcontr3} ${devcontr3} ${polcontr3} ${globshk3} ${ldv3} ${ctrnd} l3.imf_sba5 l3.imf_saf5 l3.imf_eff5 (${ev3}=${iv3}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 5

tsset cty_sct year

gen dlib5=lib-l5.lib
			  
reghdfe dlib5 ${ecfcontr5} ${devcontr5} ${polcontr5} ${globshk5} ${ldv5} ${ctrnd} l5.imf_sba5 l5.imf_saf5 l5.imf_eff5 (${ev5}=${iv5}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

restore
			  
* Column 6

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if freq_crisis_dummy_eps==0, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing
 
* Column 7

preserve

use Democracy-and-Volatility.dta,clear

tsset countryreform year

xtregar d.reform_index l.polity2 ${iv} l.reform_index i.sct_yr,fe rhotype(reg) two			  

restore			  

*==========*
* Table D4 *
*==========*

* Column 1

reghdfe Dlibpos ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 2
			  
reghdfe Dlibneg ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 3

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if ${dv}>=0, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 4

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}) if ${dv}<=0, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 5

reghdfe dabortion ${ecfcontr} ${devcontr} ${polcontr} ${globshk} l.abortion_index ${ctrnd} (${ev}=${iv}) if ref_num==1, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

* Column 6

reghdfe ${dv} l.OS_idio ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd}, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

* Column 7

reghdfe ${dv} l.epu ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd}, ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

exit




























