* This file replicates Figures 1-4 and D1-D2 of "Economic Uncertainty and Structural Reforms: Evidence from Stock Market Volatility" (A. Bonfiglioli, R. Crinò and G. Gancia)
* Input files: Main-Dataset.dta; 
*			   Average-Received-Spillovers.dta;
*			   world_coordinates.dta;
*			   world_data.dta.

clear
clear mata
clear matrix
set more off
cap set mem 5g
set matsize 5000
set maxvar 20000
scalar drop _all
matrix drop _all
macro drop _all

**************************
* Defining global macros *
**************************

global dv			"dlib"

global ev 			"l.vol"
global iv 			"l.wgt_vol_linv_distcap"
global ldv			"l.lib"
global ecfcontr 	"l.ret l.dpricesgdp l.recession l.crisis_b l.crisis_c l.crisis_s l.Dpast3_recession l.Dpast3_crisis_b l.Dpast3_crisis_c l.Dpast3_crisis_s"
global polcontr 	"l.polity2_norm l.pres l.left l.election"
global devcontr 	"l.lrgdppc f2.eu_member l.oecd_member"
global globshk		"l.wgt_dlib_linv_distcap l.wgt_lrgdppc_linv_distcap l.wgt_dpricesgdp_linv_distcap l.wgt_lrate_linv_distcap"

global ecfcontrgr	"l.ret l.dpricesgdp l.dlrgdppc l.crisis_b l.crisis_c l.crisis_s l.Dpast3_recession l.Dpast3_crisis_b l.Dpast3_crisis_c l.Dpast3_crisis_s"

global ev3 			"l3.vol"
global iv3 			"l3.wgt_vol_linv_distcap"
global ldv3			"l3.lib"
global ecfcontr3 	"l3.ret l3.dpricesgdp l3.recession l3.crisis_b l3.crisis_c l3.crisis_s l3.Dpast3_recession l3.Dpast3_crisis_b l3.Dpast3_crisis_c l3.Dpast3_crisis_s"
global polcontr3 	"l3.polity2_norm l3.pres l3.left l3.election"
global devcontr3 	"l3.lrgdppc f2.eu_member l3.oecd_member"
global globshk3		"l3.wgt_dlib_linv_distcap l3.wgt_lrgdppc_linv_distcap l3.wgt_dpricesgdp_linv_distcap l3.wgt_lrate_linv_distcap"

global ev5 			"l5.vol"
global iv5 			"l5.wgt_vol_linv_distcap"
global ldv5			"l5.lib"
global ecfcontr5 	"l5.ret l5.dpricesgdp l5.recession l5.crisis_b l5.crisis_c l5.crisis_s l5.Dpast3_recession l5.Dpast3_crisis_b l5.Dpast3_crisis_c l5.Dpast3_crisis_s"
global polcontr5 	"l5.polity2_norm l5.pres l5.left l5.election"
global devcontr5 	"l5.lrgdppc f2.eu_member l5.oecd_member"
global globshk5		"l5.wgt_dlib_linv_distcap l5.wgt_lrgdppc_linv_distcap l5.wgt_dpricesgdp_linv_distcap l5.wgt_lrate_linv_distcap"

global ev_ 			"l_vol"
global iv_ 			"l_wgt_vol_linv_distcap"
global ldv_			"l_lib"
global ecfcontr_ 	"l_ret l_dpricesgdp l_recession l_crisis_b l_crisis_c l_crisis_s l_Dpast3_recession l_Dpast3_crisis_b l_Dpast3_crisis_c l_Dpast3_crisis_s"
global polcontr_ 	"l_polity2_norm l_pres l_left l_election"
global devcontr_ 	"l_lrgdppc f2_eu_member l_oecd_member"
global globshk_		"l_wgt_dlib_linv_distcap l_wgt_lrgdppc_linv_distcap l_wgt_dpricesgdp_linv_distcap l_wgt_lrate_linv_distcap"

global csfe			"cty_sct"
global yfe			"year"
global syfe			"sct_yr"
global ayfe			"geoarea_yr"
global asyfe		"geoarea_sct_yr"
global ctrnd		"C*_year"
global imfyfe		"imf_group_aggr_yr"
global oecdyfe		"oecd_group_yr"

global cluster		"cty_n"

**********************
* Drawing the graphs *
**********************

use Main-Dataset.dta,clear

tsset cty_sct year

tab cty_sct,gen(CS)

tab sct_yr,gen(SY)

*==========*
* Figure 1 *
*==========*

preserve

keep if ref_num==1

keep if countrycode=="ARG"|countrycode=="AUS"|countrycode=="AUT"|countrycode=="BEL"|countrycode=="BGD"|countrycode=="BRA"|countrycode=="CAN"| ///
		countrycode=="CHE"|countrycode=="CHL"|countrycode=="CHN"|countrycode=="COL"|countrycode=="CZE"|countrycode=="DEU"|countrycode=="DNK"| ///
		countrycode=="ECU"|countrycode=="EGY"|countrycode=="ESP"|countrycode=="FIN"|countrycode=="FRA"|countrycode=="GBR"|countrycode=="GRC"| ///
		countrycode=="HUN"|countrycode=="IDN"|countrycode=="IND"|countrycode=="IRL"|countrycode=="IRN"|countrycode=="ISR"|countrycode=="ITA"| ///
		countrycode=="JPN"|countrycode=="KEN"|countrycode=="KOR"|countrycode=="LUX"|countrycode=="MAR"|countrycode=="MEX"|countrycode=="MYS"| ///
		countrycode=="NGA"|countrycode=="NLD"|countrycode=="NOR"|countrycode=="NZL"|countrycode=="PAK"|countrycode=="PER"|countrycode=="POL"| ///
		countrycode=="PRT"|countrycode=="ROM"|countrycode=="RUS"|countrycode=="SAU"|countrycode=="SGP"|countrycode=="SWE"|countrycode=="THA"| ///
		countrycode=="TUN"|countrycode=="TUR"|countrycode=="UKR"|countrycode=="USA"|countrycode=="VEN"|countrycode=="VNM"|countrycode=="ZAF"

bysort countrycode:egen N=nvals(year) if dlib_avg_ct!=.

bysort countrycode:egen Npos=nvals(year) if dlib_avg_ct>0&dlib_avg_ct!=.

collapse(mean) N* dlib_avg_ct vol,by(countrycode)

local share "pos"

foreach x of local share {

	gen S`x'=N`x'/N
	
}

save shares.dta,replace

use world_data.dta,clear

drop if NAME=="Antarctica"

ren ISO3 countrycode

keep _ID countrycode

replace countrycode="ROM" if countrycode=="ROU"

joinby countrycode using shares.dta,unmatched(master)

drop _merge

erase shares.dta

sum Spos

local max=r(max)

format Spos %12.2f
	
spmap Spos using world_coordinates,id(_ID) fcolor(PuBuGn) ///
			     clm(custom) clb(0 0.33 0.50 0.70 0.85 `max') ///
				 legend(on label(2 "0-0.33") label(3 "0.33-0.50") label(4 "0.50-0.70") label(5 "0.70-0.85") label(6 ">0.85")) ///
				 title("% of Years with Positive Reforms",size(small) color(black))

sum vol

local min=r(min)
local max=r(max)

format vol %12.3f
	
spmap vol using world_coordinates,id(_ID) fcolor(PuBuGn) ///
				clm(custom) clb(`min' 0.007 0.010 0.014 0.020 `max') ///
				legend(on label(2 "<0.007") label(3 "0.007-0.010") label(4 "0.010-0.014") label(5 "0.014-0.020") label(6 ">0.020")) ///
				title("Average Volatility",size(small) color(black))

restore

*==========*
* Figure 2 *
*==========*

preserve

keep if ref_num==1

keep if countrycode=="ARG"|countrycode=="AUS"|countrycode=="AUT"|countrycode=="BEL"|countrycode=="BGD"|countrycode=="BRA"|countrycode=="CAN"| ///
		countrycode=="CHE"|countrycode=="CHL"|countrycode=="CHN"|countrycode=="COL"|countrycode=="CZE"|countrycode=="DEU"|countrycode=="DNK"| ///
		countrycode=="ECU"|countrycode=="EGY"|countrycode=="ESP"|countrycode=="FIN"|countrycode=="FRA"|countrycode=="GBR"|countrycode=="GRC"| ///
		countrycode=="HUN"|countrycode=="IDN"|countrycode=="IND"|countrycode=="IRL"|countrycode=="IRN"|countrycode=="ISR"|countrycode=="ITA"| ///
		countrycode=="JPN"|countrycode=="KEN"|countrycode=="KOR"|countrycode=="LUX"|countrycode=="MAR"|countrycode=="MEX"|countrycode=="MYS"| ///
		countrycode=="NGA"|countrycode=="NLD"|countrycode=="NOR"|countrycode=="NZL"|countrycode=="PAK"|countrycode=="PER"|countrycode=="POL"| ///
		countrycode=="PRT"|countrycode=="ROM"|countrycode=="RUS"|countrycode=="SAU"|countrycode=="SGP"|countrycode=="SWE"|countrycode=="THA"| ///
		countrycode=="TUN"|countrycode=="TUR"|countrycode=="UKR"|countrycode=="USA"|countrycode=="VEN"|countrycode=="VNM"|countrycode=="ZAF"

collapse(mean) vol dlib_avg_ct,by(year)

corr dlib_avg_ct vol

local corr=string(r(rho),"%4.2f")

twoway (connected dlib_avg_ct year, mcolor(black) msize(medium) msymbol(circle_hollow) lcolor(black) lwidth(medthin) lpattern(solid)) ///
	   (connected vol year, yaxis(2) mcolor(black) msize(small) msymbol(diamond) lcolor(black) lwidth(medthin) lpattern(solid)), ///
	    ytitle(Average reform) ytitle(, size(small) color(black) margin(small)) yscale(range(-0.06 0.06)) ///
	    ylabel(-0.06(0.02)0.06, labels labsize(small) labcolor(black) ticks tlcolor(black) nogrid) ///
		ytitle(Average volatility, axis(2)) ytitle(, size(small) color(black) margin(small) axis(2)) ///
		yscale(range(0.004 0.018) axis(2)) ylabel(0.004(0.002)0.018, labels labsize(small) labcolor(black) ticks tlcolor(black) nogrid axis(2)) ///
		xtitle(, color(white)) xlabel(1970(5)2010, labels labsize(small) labcolor(black) labgap(small) ticks tlcolor(black) nogrid) ///
		caption("Correlation: `corr'", size(vsmall) color(black) position(5) orientation(horizontal) ring(0) margin(small)) ///
		scheme(sj) graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
		plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
		legend(order(1 "Average reform" 2 "Average volatility") size(small) color(black) region(fcolor(white) lcolor(white)))

restore

*==========*
* Figure 3 *
*==========*

* Lag 7

preserve

reghdfe ${dv} l7.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_l7

parmest,saving(vol_l7,replace) level(95)

use vol_l7.dta,clear

keep if parm=="L7.vol"

gen index=1

save vol_l7.dta,replace

restore
	  
* Lag 6

preserve

reghdfe ${dv} l6.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_l6

parmest,saving(vol_l6,replace) level(95)

use vol_l6.dta,clear

keep if parm=="L6.vol"

gen index=2

save vol_l6.dta,replace

restore
	  
* Lag 5

preserve

reghdfe ${dv} l5.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_l5

parmest,saving(vol_l5,replace) level(95)

use vol_l5.dta,clear

keep if parm=="L5.vol"

gen index=3

save vol_l5.dta,replace

restore
	  
* Lag 4

preserve

reghdfe ${dv} l4.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_l4

parmest,saving(vol_l4,replace) level(95)

use vol_l4.dta,clear

keep if parm=="L4.vol"

gen index=4

save vol_l4.dta,replace

restore
	  
* Lag 3

preserve

reghdfe ${dv} l3.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_l3

parmest,saving(vol_l3,replace) level(95)

use vol_l3.dta,clear

keep if parm=="L3.vol"

gen index=5

save vol_l3.dta,replace

restore
	  
* Lag 2

preserve

reghdfe ${dv} l2.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_l2

parmest,saving(vol_l2,replace) level(95)

use vol_l2.dta,clear

keep if parm=="L2.vol"

gen index=6

save vol_l2.dta,replace

restore
	  
* Lag 1

preserve

reghdfe ${dv} l.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_l1

parmest,saving(vol_l1,replace) level(95)

use vol_l1.dta,clear

keep if parm=="L.vol"

gen index=7

save vol_l1.dta,replace

restore
	  
* Lag 0

preserve

reghdfe ${dv} vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_l0

parmest,saving(vol_l0,replace) level(95)

use vol_l0.dta,clear

keep if parm=="vol"

gen index=8

save vol_l0.dta,replace

restore
	  
* Lead 1

preserve

reghdfe ${dv} f.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_f1

parmest,saving(vol_f1,replace) level(95)

use vol_f1.dta,clear

keep if parm=="F.vol"

gen index=9

save vol_f1.dta,replace

restore
	  
* Lead 2

preserve

reghdfe ${dv} f2.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_f2

parmest,saving(vol_f2,replace) level(95)

use vol_f2.dta,clear

keep if parm=="F2.vol"

gen index=10

save vol_f2.dta,replace

restore
	  
* Lead 3

preserve

reghdfe ${dv} f3.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_f3

parmest,saving(vol_f3,replace) level(95)

use vol_f3.dta,clear

keep if parm=="F3.vol"

gen index=11

save vol_f3.dta,replace

restore
	  
* Lead 4

preserve

reghdfe ${dv} f4.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_f4

parmest,saving(vol_f4,replace) level(95)

use vol_f4.dta,clear

keep if parm=="F4.vol"

gen index=12

save vol_f4.dta,replace

restore
	  
* Lead 5

preserve

reghdfe ${dv} f5.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_f5

parmest,saving(vol_f5,replace) level(95)

use vol_f5.dta,clear

keep if parm=="F5.vol"

gen index=13

save vol_f5.dta,replace

restore

* Lead 6

preserve

reghdfe ${dv} f6.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_f6

parmest,saving(vol_f6,replace) level(95)

use vol_f6.dta,clear

keep if parm=="F6.vol"

gen index=14

save vol_f6.dta,replace

restore

* Lead 7

preserve

reghdfe ${dv} f7.vol ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd},absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) old keepsing

estimates store vol_f7

parmest,saving(vol_f7,replace) level(95)

use vol_f7.dta,clear

keep if parm=="F7.vol"

gen index=15

save vol_f7.dta,replace

restore

preserve

clear

local dataset "l7 l6 l5 l4 l3 l2 l1 l0 f1 f2 f3 f4 f5 f6 f7"

foreach x of local dataset {

	append using vol_`x'.dta
	
	erase vol_`x'.dta
	
}

twoway scatter estimate index,msymbol(circle_hollow) mcolor(black) lcolor(black) || ///	
	   rspike min95 max95 index,lcolor(red) ///
	   xlabel(1 "t-7" 2 "t-6" 3 "t-5" 4 "t-4" 5 "t-3" 6 "t-2" 7 "t-1" 8 "t" ///
			  9 "t+1" 10 "t+2" 11 "t+3" 12 "t+4" 13 "t+5" 14 "t+6" 15 "t+7" ///
	   ,labels labsize(small) labcolor(black)) ///
	   ylabel(,nogrid labels labsize(small) labcolor(black)) ///
	   xtitle("Period to which volatility refers", margin(medium) size(small) color(black)) ///
	   yline(0,lpatter(dash) lcolor(black) lwidth(thin)) ///
	   legend(order(1 2) size(small) color(black) label(1 "Coefficient on volatility") label(2 "Confidence interval") ///
	   region(fcolor(none) lcolor(none))) graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))

restore

*==========*
* Figure 4 *
*==========*

forvalues delta=0(1)220 {

	matrix drop _all
	scalar drop _all
	
	preserve
	
	gen ev=${ev}
	gen iv=${iv}
		
	local gamma=2.055*(1/6)*(`delta'/100)		
	
	qui plausexog uci ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} C1_year-C59_year CS* SY* (ev=iv), ///
				  vce(cluster ${cluster}) gmin(-`gamma') gmax(`gamma') level(0.90)
		
	scalar delta=(`delta'/100)
	
	scalar cil=e(lb_ev)
	
	scalar ciu=e(ub_ev)
		
	matrix res=(delta,cil,ciu)
		
	svmat res
		
	keep res*
	
	keep if res1!=.
		
	ren res1 delta
	ren res2 cil
	ren res3 ciu
		
	save PE-Full-Specification-`delta'.dta,replace
	
	restore

}

preserve

clear

forvalues delta=0(1)220 {
	
	append using PE-Full-Specification-`delta'.dta
	
	erase PE-Full-Specification-`delta'.dta

}

* Drawing the graph

twoway (line ciu delta, lcolor(gs10) lwidth(thin) lpattern(solid)) ///
	   (line cil delta, lcolor(gs10) lwidth(thin) lpattern(solid)), yscale(range(-0.2 4.4)) ///
	   yline(0, lwidth(medium) lpattern(dash) lcolor(black)) yline(2.055, lwidth(thin) lpattern(solid) lcolor(red)) ///
	   ylabel(-.2 0 .6 1.2 1.8 2.055 2.4 3 3.6 4.2, labels labsize(small) labcolor(black) angle(horizontal) noticks nogrid) ///
	   xtitle(delta) xtitle(, size(small) color(black)) xlabel(0(0.1)2.2, labels labsize(small) labcolor(black) noticks nogrid) ///
	   legend(off) scheme(sj) graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))

restore

*===========*
* Figure D1 *
*===========*

preserve

collapse(mean) av_distcap,by(countrycode)

joinby countrycode using Average-Received-Spillovers.dta,unmatched(master)

drop _merge

drop if countrycode=="PHL"

gen ln_average_connectedness=ln(average_connectedness)

gen ln_av_distcap=ln(av_distcap)

reg ln_average_connectedness ln_av_distcap,rob

local coeff=string(_b[ln_av_distcap],"%4.3f")

local se=string(_se[ln_av_distcap],"%4.3f")

local r2=string(e(r2),"%4.2f")

local N=string(e(N),"%4.0f")
	   
twoway (scatter ln_average_connectedness ln_av_distcap, msymbol(none) mlabel(countrycode) mlabsize(small) mlabcolor(black)) ///
	   (lfit ln_average_connectedness ln_av_distcap, lcolor(black) lwidth(medium) lpattern(solid)), ///
	   ytitle(Log Volatility Connectedness Index) ytitle(, size(small) color(black) margin(small)) ///
	   ylabel(, labels labsize(small) labcolor(black) ticks tlcolor(black) nogrid) xtitle(Log Distance) ///
	   xtitle(, size(small) color(black) margin(small)) legend(off) ///
	   caption("Coeff. [s.e.]: `coeff' [`se']; R2: `r2'; N: `N'", size(vsmall) color(red) position(7) orientation(horizontal) ring(0) margin(small)) ///	   	   
	   scheme(sj) graphregion(fcolor(white) ///
	   lcolor(white) ifcolor(white) ilcolor(white)) plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))
	   
restore

*===========*
* Figure D2 *
*===========*

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster},suite(mwc)) stages(first reduced) old keepsing

regsave ${ev} using Alternative-Standard-Errors-R2.dta,ci l(95) replace
		
reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster year,suite(mwc)) stages(first reduced) old keepsing
 
regsave ${ev} using Alternative-Standard-Errors-R2.dta,ci l(95) append

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster sct_yr,suite(mwc)) stages(first reduced) old keepsing
 
regsave ${ev} using Alternative-Standard-Errors-R2.dta,ci l(95) append

egen ga_yr=group(wb_geoarea year)

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ga_yr,suite(mwc)) stages(first reduced) old keepsing
 
regsave ${ev} using Alternative-Standard-Errors-R2.dta,ci l(95) append

egen ga_sct_yr=group(wb_geoarea ref_num year)

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ga_sct_yr,suite(mwc)) stages(first reduced) old keepsing
 
regsave ${ev} using Alternative-Standard-Errors-R2.dta,ci l(95) append

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster} year,suite(mwc)) stages(first reduced) old keepsing
 
regsave ${ev} using Alternative-Standard-Errors-R2.dta,ci l(95) append

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster} sct_yr,suite(mwc)) stages(first reduced) old keepsing
 
regsave ${ev} using Alternative-Standard-Errors-R2.dta,ci l(95) append

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster} ga_yr,suite(mwc)) stages(first reduced) old keepsing
 
regsave ${ev} using Alternative-Standard-Errors-R2.dta,ci l(95) append

reghdfe ${dv} ${ecfcontr} ${devcontr} ${polcontr} ${globshk} ${ldv} ${ctrnd} (${ev}=${iv}), ///
		absorb(${csfe} ${syfe}) vce(cluster ${cluster} ga_sct_yr,suite(mwc)) stages(first reduced) old keepsing
 
regsave ${ev} using Alternative-Standard-Errors-R2.dta,ci l(95) append

preserve

tsset cty_sct year

gen l_vol=l.vol
gen l_wgt_vol_linv_distcap=l.wgt_vol_linv_distcap

gen l_lib=l.lib

gen l_ret=l.ret 
gen l_dpricesgdp=l.dpricesgdp 
gen l_recession=l.recession 
gen l_crisis_b=l.crisis_b 
gen l_crisis_c=l.crisis_c 
gen l_crisis_s=l.crisis_s 
gen l_Dpast3_recession=l.Dpast3_recession
gen l_Dpast3_crisis_b=l.Dpast3_crisis_b
gen l_Dpast3_crisis_c=l.Dpast3_crisis_c
gen l_Dpast3_crisis_s=l.Dpast3_crisis_s

gen l_polity2_norm=l.polity2_norm 
gen l_pres=l.pres 
gen l_left=l.left 
gen l_election=l.election

gen l_lrgdppc=l.lrgdppc 
gen f2_eu_member=f2.eu_member 
gen l_oecd_member=l.oecd_member

gen l_wgt_dlib_linv_distcap=l.wgt_dlib_linv_distcap
gen l_wgt_lrgdppc_linv_distcap=l.wgt_lrgdppc_linv_distcap
gen l_wgt_dpricesgdp_linv_distcap=l.wgt_dpricesgdp_linv_distcap
gen l_wgt_lrate_linv_distcap=l.wgt_lrate_linv_distcap

drop if capital_latitude==.|capital_longitude==.

sum cl_5c_distcap

local cut_off_5c=r(max)

acreg ${dv} ${ecfcontr_} ${devcontr_} ${polcontr_} ${globshk_} ${ldv_} ${ctrnd} (${ev_}=${iv_}), ///
			id(${csfe}) time(${syfe}) pfe1(${csfe}) pfe2(${syfe}) ///
		    spatial latitude(capital_latitude) longitude(capital_longitude) dist(`cut_off_5c') hac lagcutoff(15)

regsave l_vol using Alternative-Standard-Errors-R2.dta,ci l(95) append

sum cl_10c_distcap

local cut_off_10c=r(max)

acreg ${dv} ${ecfcontr_} ${devcontr_} ${polcontr_} ${globshk_} ${ldv_} ${ctrnd} (${ev_}=${iv_}), ///
			id(${csfe}) time(${syfe}) pfe1(${csfe}) pfe2(${syfe}) ///
		    spatial latitude(capital_latitude) longitude(capital_longitude) dist(`cut_off_10c') hac lagcutoff(15)

regsave l_vol using Alternative-Standard-Errors-R2.dta,ci l(95) append

sum cl_15c_distcap

local cut_off_15c=r(max)

acreg ${dv} ${ecfcontr_} ${devcontr_} ${polcontr_} ${globshk_} ${ldv_} ${ctrnd} (${ev_}=${iv_}), ///
			id(${csfe}) time(${syfe}) pfe1(${csfe}) pfe2(${syfe}) ///
		    spatial latitude(capital_latitude) longitude(capital_longitude) dist(`cut_off_15c') hac lagcutoff(15)

regsave l_vol using Alternative-Standard-Errors-R2.dta,ci l(95) append

sum cl_20c_distcap

local cut_off_20c=r(max)

acreg ${dv} ${ecfcontr_} ${devcontr_} ${polcontr_} ${globshk_} ${ldv_} ${ctrnd} (${ev_}=${iv_}), ///
			id(${csfe}) time(${syfe}) pfe1(${csfe}) pfe2(${syfe}) ///
		    spatial latitude(capital_latitude) longitude(capital_longitude) dist(`cut_off_20c') hac lagcutoff(15)

regsave l_vol using Alternative-Standard-Errors-R2.dta,ci l(95) append

sum cl_30c_distcap

local cut_off_30c=r(max)

acreg ${dv} ${ecfcontr_} ${devcontr_} ${polcontr_} ${globshk_} ${ldv_} ${ctrnd} (${ev_}=${iv_}), ///
			id(${csfe}) time(${syfe}) pfe1(${csfe}) pfe2(${syfe}) ///
		    spatial latitude(capital_latitude) longitude(capital_longitude) dist(`cut_off_30c') hac lagcutoff(15)

regsave l_vol using Alternative-Standard-Errors-R2.dta,ci l(95) append
		   
restore

preserve

use Alternative-Standard-Errors-R2.dta,clear

replace coef=round(coef,0.001)

drop var stderr N r2

gen n=_n

twoway scatter coef n,msymbol(circle_hollow) mcolor(black) lcolor(black) || ///	
	   rspike ci_lower ci_upper n,lcolor(red) ///
	   xlabel(1 "Baseline" 2 "Cluster by year" 3 "Cluster by sector-year" 4 "Cluster by area-year" ///
			  5 "Cluster by area-sector-year" 6 "Two-way cluster, country & year" 7 "Two-way cluster, country & sector-year" ///
			  8 "Two-way cluster, country & area-year" 9 "Two-way cluster, country & area-sector-year" ///
			  10 "Conley (1999), cut-off distance: 8,929 Km" 11 "Conley (1999), cut-off distance: 10,081 Km" ///
			  12 "Conley (1999), cut-off distance: 11,327 Km" 13 "Conley (1999), cut-off distance: 12,822 Km" ///
			  14 "Conley (1999), cut-off distance: 15,948 Km",labsize(small) angle(forty_five)) ylabel(,nogrid) ///
	   ylabel(, labels labsize(small) labcolor(black)) ///
	   xtitle(, color(white)) ylabel(-0.5(1)3.5,labsize(small)) /// 
	   yline(0, lwidth(medium) lpattern(solid) lcolor(black)) ///
	   legend(order(1 2) label(1 "Coefficient on lagged volatility") label(2 "Confidence interval") region(fcolor(none) lcolor(none)) size(small)) ///
	   graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))
	   
restore

erase Alternative-Standard-Errors-R2.dta

exit




























