* This file replicates Tables 1-2 of "Economic Uncertainty and Structural Reforms: Evidence from Stock Market Volatility" (A. Bonfiglioli, R. Crinò and G. Gancia)
* Input files: Main-Dataset.dta.

clear
clear mata
clear matrix
set more off
cap set mem 5g
set matsize 5000
set maxvar 20000
scalar drop _all
matrix drop _all
macro drop _all

**************************
* Defining global macros *
**************************

global dv			"dlib"

global ev 			"l.vol"
global iv 			"l.wgt_vol_linv_distcap"
global ldv			"l.lib"
global ecfcontr 	"l.ret l.dpricesgdp l.recession l.crisis_b l.crisis_c l.crisis_s l.Dpast3_recession l.Dpast3_crisis_b l.Dpast3_crisis_c l.Dpast3_crisis_s"
global polcontr 	"l.polity2_norm l.pres l.left l.election"
global devcontr 	"l.lrgdppc f2.eu_member l.oecd_member"
global globshk		"l.wgt_dlib_linv_distcap l.wgt_lrgdppc_linv_distcap l.wgt_dpricesgdp_linv_distcap l.wgt_lrate_linv_distcap"

global ecfcontrgr	"l.ret l.dpricesgdp l.dlrgdppc l.crisis_b l.crisis_c l.crisis_s l.Dpast3_recession l.Dpast3_crisis_b l.Dpast3_crisis_c l.Dpast3_crisis_s"

global ev3 			"l3.vol"
global iv3 			"l3.wgt_vol_linv_distcap"
global ldv3			"l3.lib"
global ecfcontr3 	"l3.ret l3.dpricesgdp l3.recession l3.crisis_b l3.crisis_c l3.crisis_s l3.Dpast3_recession l3.Dpast3_crisis_b l3.Dpast3_crisis_c l3.Dpast3_crisis_s"
global polcontr3 	"l3.polity2_norm l3.pres l3.left l3.election"
global devcontr3 	"l3.lrgdppc f2.eu_member l3.oecd_member"
global globshk3		"l3.wgt_dlib_linv_distcap l3.wgt_lrgdppc_linv_distcap l3.wgt_dpricesgdp_linv_distcap l3.wgt_lrate_linv_distcap"

global ev5 			"l5.vol"
global iv5 			"l5.wgt_vol_linv_distcap"
global ldv5			"l5.lib"
global ecfcontr5 	"l5.ret l5.dpricesgdp l5.recession l5.crisis_b l5.crisis_c l5.crisis_s l5.Dpast3_recession l5.Dpast3_crisis_b l5.Dpast3_crisis_c l5.Dpast3_crisis_s"
global polcontr5 	"l5.polity2_norm l5.pres l5.left l5.election"
global devcontr5 	"l5.lrgdppc f2.eu_member l5.oecd_member"
global globshk5		"l5.wgt_dlib_linv_distcap l5.wgt_lrgdppc_linv_distcap l5.wgt_dpricesgdp_linv_distcap l5.wgt_lrate_linv_distcap"

global ev_ 			"l_vol"
global iv_ 			"l_wgt_vol_linv_distcap"
global ldv_			"l_lib"
global ecfcontr_ 	"l_ret l_dpricesgdp l_recession l_crisis_b l_crisis_c l_crisis_s l_Dpast3_recession l_Dpast3_crisis_b l_Dpast3_crisis_c l_Dpast3_crisis_s"
global polcontr_ 	"l_polity2_norm l_pres l_left l_election"
global devcontr_ 	"l_lrgdppc f2_eu_member l_oecd_member"
global globshk_		"l_wgt_dlib_linv_distcap l_wgt_lrgdppc_linv_distcap l_wgt_dpricesgdp_linv_distcap l_wgt_lrate_linv_distcap"

global csfe			"cty_sct"
global yfe			"year"
global syfe			"sct_yr"
global ayfe			"geoarea_yr"
global asyfe		"geoarea_sct_yr"
global ctrnd		"C*_year"
global imfyfe		"imf_group_aggr_yr"
global oecdyfe		"oecd_group_yr"

global cluster		"cty_n"

************************************
* Computing descriptive statistics *
************************************

use Main-Dataset.dta,clear

tsset cty_sct year

*=========*
* Table 1 *
*=========*

forvalues x=1/6 {

	sum lib if ref_num==`x'&${ev}!=.
	
	scalar N_`x'=r(N)
	
	scalar av_`x'=r(mean)
	
	scalar sd_`x'=r(sd)

}

matrix descr_stats=(N_1,av_1,sd_1\N_2,av_2,sd_2\N_3,av_3,sd_3\N_4,av_4,sd_4\N_5,av_5,sd_5\N_6,av_6,sd_6)
	
matrix rownames descr_stats="Trade" "Current Account" "Product Market" "Agriculture" ///
							"Domestic Finance" "Capital Account"

matrix colnames descr_stats="Obs" "Mean" "Std. Dev."
		
pwcorr TR CUR100 NW AG DF CAP100 if ref_num==1&${ev}!=.,sig

*=========*
* Table 2 *
*=========*

forvalues y=1/6 {

	preserve

	keep if ref_num==`y'

	sum dlib if ${ev}!=.,d

	scalar dlib_`y'_m=r(mean)

	count if dlib!=.&${ev}!=.

	scalar N_dlib_`y'=r(N)

	count if dlib==0&${ev}!=.

	scalar Nzer_dlib_`y'=r(N)

	count if dlib<0&${ev}!=.

	scalar Nneg_dlib_`y'=r(N)

	count if dlib>0&dlib!=.&${ev}!=.

	scalar Npos_dlib_`y'=r(N)

	local share "zer pos neg"

	foreach x of local share {

		scalar S`x'_dlib_`y'=N`x'_dlib_`y'/N_dlib_`y'

	}

	sum dlib if dlib<0&${ev}!=.

	scalar dlib_`y'_mneg=r(mean)

	sum dlib if dlib>0&dlib!=.&${ev}!=.

	scalar dlib_`y'_mpos=r(mean)

	matrix pn_dlib_`y'=(Npos_dlib_`y',Spos_dlib_`y',Nneg_dlib_`y',Sneg_dlib_`y',Nzer_dlib_`y',Szer_dlib_`y', ///
					    dlib_`y'_m,dlib_`y'_mpos,dlib_`y'_mneg)

	restore

}

matrix pn_dlib=(pn_dlib_1\pn_dlib_2\pn_dlib_3\pn_dlib_4\pn_dlib_5\pn_dlib_6)

matrix rownames pn_dlib="Trade" "Current Account" "Product Market" "Agriculture" ///
						"Domestic Finance" "Capital Account"

matrix colnames pn_dlib="# Positive Changes" "% Positive Changes" "# Negative Changes" "% Negative Changes" "# Zero Changes" "% Zero Changes" ///
						"Mean (All Changes)" "Mean (Positive Changes)" "Mean (Negative Changes)"

exit




























