

%**************************************************************************************************************
%******************************* READ THE DATA ****************************************************************
%**************************************************************************************************************
cd 'C:\Users\arnaud.dupuy\Dropbox\Alfred_Arnaud\MatchingWithObservedTransfers'
%***
addpath(genpath('Code'))


%%%% Set up
digits(50)
run('Code\globals.m')
global tol2
tol = 1E-10;
tol2 = 1E-8;
global estimation
global StdRisk AveRisk meanW meanW_wo AveRisk_wo StdRisk_wo
global Gradln1 Gradln2
global ai_tilda_Old gra_old_da_tilda_dA
global incl_pub specification mx_A my_A mx_G my_G
global maxIteration
global interactions
global sigma2_stor sigma1_stor
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%SOME CHOICES TO BE MADE UPFRONT%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%Choosing specification of alphas and gammas:
%Specification == 1: full specification: all x's and all y's are used for the alpha and gamma terms of the surplus
%Specification == 2: %same specification for alpha and gamma, Y (risk and
%public) X, (educ,expe and Union).Good sigmas but no interaction for alpha
%and 3 (out of 6) for gamma.

%Specification == 3: Different specification for alpha and gamma: for alpha we use risk and public dummy for y and education, experience and marital status (X1, X2 and X4 respectively)
%while for gamma we use risk and public dummy for y and education, experience and union membership  (X1, X2
%and X5 respectively): we find that marital status does not interact sig with
%any y's in alpha
%Specification == 4: Different specification for alpha and gamma: For alpha we use risk and public for y and education and experience in X (X1, and X2). For Gamma we use risk and public dummy as Y (Y1 and Y2) and education, experience and union membership (X1, X2 and X5 respectively)
%results sigma1 is at the lower limit, otherwise good results, but no sig
%interaction of X's with risk, although public sector interacts sig with
%education
%
%Specification == 5: For alpha we use only risk for y and education, experience, gender in X (X1, X2 and X3). For Gamma we use risk and public dummy as Y (Y1 and Y2) and education, experience and union membership (X1, X2 and X5 respectively)
%Bad results: sigmas are at the lower limit (0.05) and alphas and gammas
%don't make sense.
%Specification == 6: For alpha we use only risk for y and education, experience, gender in X (X1, X2 and X3). For Gamma we use only public dummy as Y (Y1 and Y2) and education, experience and union membership (X1, X2 and X5 respectively)
%Bad results: sigmas are at the lower limit (0.05) and alphas and gammas
%don't make sense.
%Specification == 7: Different specification for alpha and gamma: For alpha we use risk and public for y and education and gender in X (X1, and X3). For Gamma we use risk and public dummy as Y (Y1 and Y2) and education, experience and union membership (X1, X2 and X5 respectively)
%results : sigmas are at their lower limit and hence weird alphas and
%gammas.
%Specification == 8: Different specification for alpha and gamma: For alpha we use risk and public for y and gender in X (X3). For Gamma we use risk and public dummy as Y (Y1 and Y2) and education, experience and union membership (X1, X2 and X5 respectively)
%results : again sigmas are at the lower bound and alphas and gammas don't
%make sense.
%Specification == 9: Different specification for alpha and gamma: For alpha we use risk and public for y and education in X (X1). For Gamma we use risk and public dummy as Y (Y1 and Y2) and education, experience and union membership (X1, X2 and X5 respectively)
%results : again sigmas are at the lower bound and alphas and gammes don't
%make sense.
%Specification == 10:Different specification for alpha and gamma: For alpha we use only public for y and education, experience and union in X (X1, X2 and X5). For Gamma we use risk and public dummy as Y (Y1 and Y2) and education, experience, genre and union membership (X1, X2, X3 and X5 respectively)
%results : very good results, good sigmas and other coefficients.
%Specification == 11: no interactions
%results : good results, VOSL = 7M sig at 1%, sigma1+sigma2 = 2*0.0617
%Specification == 12: interactions for alpha come from y (risk and public sector)  and education and gender for X (X1 and X3), for gamma (risk and public sector) for y and education, experience and union for X (X1, X2 and X5)
%results : sigmas are at the lower limit! (0.01), VOSL=5M sig at 5% and VOSL_wo = 11M and sig 1%. 
%Specification == 13: interactions for alpha come from y (risk and public
%sector) for y and gender for X (X3), for gamma (risk and public sector) for y and education, experience and union for X (X1, X2 and X5)
%results : sigmas are at the lower limit! (0.05), VOSL=4M sig at 5% and VOSL_wo = 28M and sig 1%.
%Specification == 14: no interactions for alpha, interactions for gamma (risk and public sector) for y and education, experience and union for X (X1, X2 and X5)
%results : sigma 1 is at the lower bound, otherwise nice results


%%%%
%%%Suggestion: specification 11: only main effects
%%%Then specification 15: lot's of interaction (incl. gender), but since
%%%interaction between risk and X and gender,experience and Y not sig in alpha, kick them out for alpha
%%%Then specification 10: alpha we use only public for y and education in X (X1). For Gamma we use risk and public dummy as Y (Y1 and Y2) and education, experience (X1, X2 respectively)
%results : very good results, good sigmas and other coefficients.

%Specification == 15 %Same specification for alpha and gamma using risk and public dummy for y and education, experience, gender (X1, X2, X3 respectively)
%good sigmas but risk and risk*gender are not sig. No interaction of risk
%and X signi while public * education and union are sig. For gamma almost
%all interactions are sig.

%Specification == 16 %Alpha using risk and public dummy for y and education, experience (X1, X2 respectively)
%Gamma using risk and public dummy for y and education, experience, gender (X1, X2, X3 respectively)
%good sigmas, risk is sig and 6.4M, no inter with risk sig in alpha, but
%interaction with public are, gamma 6 out of 8 interactions sig (3 for risk
%and 3 for public

%Specification == 17 %Alpha using public dummy for y and education, experience, (X1, X2, respectively)
%Gamma using risk and public dummy for y and education, experience, gender (X1, X2, X3 respectively)
%good sigmas, risk is sig and 6.4M, no inter with risk sig in alpha, but
%interaction with public are, gamma 6 out of 8 interactions sig (3 for risk
%and 3 for public

%Specification == 10:Different specification for alpha and gamma: For alpha we use only public for y and education and union in X (X1 and X5). 
%For Gamma we use risk and public dummy as Y (Y1 and Y2) and education, experience, gender (X1, X2, X3 respectively)
%results : very good results, good sigmas and other coefficients.

%Preferred specification as chosen in the paper.
specification = 10;


%%%choosing a normal (lognorm=0) or lognormal (lognorm=1) distribution of errors for the transfer
%%%equation 
lognorm=0;
%one can also choose to set transfer = log(wage), in that case, choose
%logwage=1
logwage=1;

%Include dummy public sector as y_var : if yes then incl_pub==1
incl_pub=1;


%%%Choose estimation =1 if you want to run the estimation of the parameters
%%%or choose estimation =0 if you want to use saved estimates and compile
%%%tables or simulations based on those
estimation=0;

%If using _toy data means we use a small sample of the true data to test
%the code
%data_all=xlsread('Data\workingdataset_occind_toy.xml');
data_all=xlsread('Data\workingdataset_occind.xml');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%***CREATE DATA VECTORS AND MATRIX
[X,Y,wage]=extract_data_QE(data_all);
if logwage==1
    w = log(wage);
else
    w = wage;
end
%[N,M] = size(data_all);
[N,Mx] = size(X);
[~,My] = size(Y);
[~,Mw] = size(w);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%Initialize Parameters
Ai = ones(N,1);
Bj = ones(N,1);
t_stor = 0;
sigma1_stor=1.01;
sigma2_stor=1.01;
FEx = [];
FEy = [];
logL3 = -5;
weightL2 = 1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%CHOICE VARIABLES%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%CHOOSE the Order of the polynomial for FE in X and Y respectively.
%specify a different order of polynomial for different X and Y
same_order = 0;
if same_order==0
    %Ox_vec must be of size (Mx)
    Ox_vec = [1 2 1 1 1 1 1];
    if specification == 11 || specification == 12 || specification == 15 %|| 11
        Ox_vec = [2 2 1 1 1 1 1];
    end
    %Oy_vec must be of size (My)
    if incl_pub==1
        Oy_vec = [1 1];
    else
        Oy_vec = [1];
    end
else
    Ox = 1;
    Oy = 1;
end

%Whether to include options, 0 is No, 1 is yes. 
gridsearch_sigmas=0; %generate a grid search for sigmas,
check_gradient = 0;%checking gradient
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% Creating Interaction variables %%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if same_order == 0 
     PX=poly_terms(X, Ox_vec);
     PY=poly_terms(Y, Oy_vec);
else
     PX=poly_terms(X, Ox);
     PY=poly_terms(Y, Oy);
end

%%%%Defining the basis functions psi_k(xi,yj) 
%%%%BEWARE: SINCE THERE ARE TAXES INVOLVED WE NEED TO WORK WITH "TILDE BASIS UNCTIONS"
%%%%I.E. THOSE PRE-MULTIPLIED WITH THE LAMBDA'S IN THE PAPER
tEx = zeros(N,1);
tEy = zeros(N,1);
tFy = zeros(N,1);
%[lambdaEx,X_tilda,PY_tilda,BF_A_tilda,lambdaFy,Y_tilda,BF_G_tilda] = GenBFTilde(tEx,tEy,tFy,X,PX,Y,PY);
[BF_A_tilda,BF_G_tilda] = GenBFTilde_QE(X,PX,Y,PY);


%Here below we derive basis function for tax rates = 0 which is used as a
%to derive initial values for Aopti
%tEx0 = zeros(N,1);
%tEy0 = zeros(N,1);
%tFy0 = zeros(N,1);
%[lambdaEx0,X_tilda0,PY_tilda0,BF_A_tilda0,lambdaFy0,Y_tilda0,BF_G_tilda0] = GenBFTilde(tEx0,tEy0,tFy0,X,PX,Y,PY);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%% OPTIMIZATION OPTIONS %%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%SPY = 0;
maxIteration = 1000;
maxIter = 1000;
maxFunEvals = 10000;
%options =optimset('Display','iter','GradObj','on','LargeScale','on','HessUpdate','bfgs','MaxIter',maxIter,'MaxFunEvals',maxFunEvals,'TolFun',1e-8,'TolX',1e-8);
%options =optimset('Display','iter','GradObj','off','LargeScale','on','HessUpdate','bfgs','MaxIter',maxIter,'MaxFunEvals',maxFunEvals,'TolFun',1e-6,'TolX',1e-8);
%options =optimset('Display','iter','GradObj','off','LargeScale','on','HessUpdate','bfgs','MaxIter',maxIter,'MaxFunEvals',maxFunEvals,'TolFun',1e-8,'TolX',1e-8,'PlotFcn',(@optimplotfirstorderopt));
options = optimoptions('fminunc','Display','iter','Algorithm','quasi-newton','SpecifyObjectiveGradient',true,'HessianFcn',[],'MaxIter',maxIter,'TolFun',1e-8,'TolX',1e-8);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%% Initialization of parameters %%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%K_A parameters in Alpha (incl FX), K_G parms in Gamma (incl. FX), 1 const parm for wage reg and 1 scale parm and SPY parms for FX in performance reg
[~,~,K_A] = size(BF_A_tilda);
[~,N,K_G] = size(BF_G_tilda);
NumbPara = K_A+K_G+1;
%NumbPara = K_A+K_G;

startMatrix = 0.1*ones(1,NumbPara)';
%parameters for the small sample
%startMatrix = [-0.3081 0.0298 -0.6463 0.3014 0.1863 0.7118 0.4797 4.4065 0.7912 -0.8351 3.8250 0.8570 0.5570 -1.0230 7.6186 4.0028 -1.3129 -2.2529 0.2760 -0.0471 -0.8782 -0.3140 -0.2118 -0.5932 -0.4993 -4.4088 -0.1200 1.0248 -3.7954 -0.6411 -0.0053 1.0006 -7.6002 -4.0509 3.4371 0.7939 -1.1693 1.1441 1.5782  0.5934 -1.9363 0.3830 0.5419 -0.7593 18.7986]';
%Parameters for the full sample
%startMatrix = [-0.3225 0.0048 -0.9257 0.1260 0.1654 -0.0887 -0.0132 -0.3730 1.4656 -0.4502 1.0126 0.1894 0.9528 -0.3268 2.1355 0.5990 -0.9594 -1.5354 0.2690 0.0449 0.1586 -0.1204 -0.1357 0.1473 -0.0029 0.1958 -0.9135 0.5774 -0.8860 0.1002 -0.4055 0.2726 -2.3913 -1.4373 2.9588 1.7123 -1.4300 0.4750 1.4201 0.8333 -1.6224 0.5679 0.4218 -0.8205 20.2494]';
if logwage==1
    %startMatrix=[0.0207 -0.0023 -0.0478 0.0204 -0.0176 0.0407 0.0830 0.0218 0.1939 0.0141 0.0219 0.0035 0.1345 -0.0293 0.1601 -0.2082 -0.1035 0.0233 -0.0498 0.0402 -0.1825 -0.0034 -0.0238 -0.0383 -0.0454 -0.2223 0.0775 -0.0547 0.1026 0.1514 0.2053 0.1925 0.3587 -0.0526 0.1754 0.1125 -0.0878 -0.0118 0.0529 -0.0263 -0.1525 0.0344 0.0139 -0.0329 4.7481]';
    %startMatrix=[0.0073 0.0030 -0.0648 -0.0013 -0.0038 0.0069 0.0274 -0.0350 0.1275 -0.0007 0.0329 0.0114 0.1041 0.0302 -0.0048 -0.0450 -0.0828 -0.0719 -0.0304 0.0171 -0.2707 0.0102 -0.0039 0.0753 0.0576 -0.0812 0.1213 0.0601 0.0526 0.0842 0.2276 -0.0721 0.0102 -0.1917 0.1450 0.0865 -0.0922 0.0163 0.0255 0.0609 -0.1078 0.0925 0.0164 -0.0475 4.9930]';
    %startMatrix=[0.0175 0.0063 -0.0392 -0.0054 0.0088 -0.0016 0.0513 -0.0897 0.1207 0.0259 0.0262 0.0491 0.1291 -0.0387 0.0355 -0.1622 -0.0535 -0.0215 -0.0355 0.0423 -0.1565 0.0061 -0.0069 -0.0049 -0.0889 -0.1759 0.1832 0.0837 0.0930 0.1088 0.2079 -0.0597 -0.0054 -0.3661 0.1270 0.0772 -0.0850 0.0098 0.0131 0.0579 -0.1265 0.0630 0.0109 -0.0395 4.8447]';
    %startMatrix=[0.0077 0.0041 -0.0405 0.0001 -0.0011 -0.0031 0.0211 -0.0171 0.1281 -0.0081 0.0356 0.0117 0.1027 0.0266 -0.0033 -0.0443 -0.0444 -0.0676 -0.0372 0.0351 -0.1751 0.0110 0.0047 0.0251 -0.0232 -0.0462 0.1208 0.0546 0.0525 0.0918 0.2291 -0.0589 0.0063 -0.1756 0.1470 0.0870 -0.0828 0.0113 0.0237 0.0556 -0.1143 0.0887 0.0158 -0.0481 5.0364]';
    year = 2017;
    %read estimation results: Aopti
    filename2=strcat('Outputs/','Estimates_Aopti_tilde_QE_sp',num2str(specification),num2str(year));
    startMatrix=xlsread(filename2);
    startMatrix = startMatrix(1:NumbPara,1);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%Checking gradient validity%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if check_gradient == 1
%run('check_grad.m')

pertu = 1e-4;
A00 = 0.1+0*startMatrix;
A11 = A00;
kk=20;
A11(kk,1) = A00(kk,1)-pertu;
A22 = A00;
A22(kk,1) = A00(kk,1)+pertu;

[minus_loglike00,minus_Grad00] = ObjectiveFunction_ML(A00,BF_A_tilda,BF_G_tilda,w);
logL100 = logL1;
Gradln100 = Gradln1;
Gradln200 = Gradln2;
gra_old_da_tilda_dA_00 = gra_old_da_tilda_dA;
ai_tilda_Old_00 = ai_tilda_Old;
[minus_loglike11,minus_Grad11] = ObjectiveFunction_ML(A11,BF_A_tilda,BF_G_tilda,w);
logL111=logL1;
logL211=logL2;
ai_tilda_Old_11 = ai_tilda_Old;
[minus_loglike22,minus_Grad22] = ObjectiveFunction_ML(A22,BF_A_tilda,BF_G_tilda,w);
logL122=logL1;
logL222=logL2;
ai_tilda_Old_22 = ai_tilda_Old;


grad_analytic = minus_Grad00(1,kk)
grad_nume = (minus_loglike22 - minus_loglike11)./(A22(kk,1)-A11(kk,1) )

Gradln100(1,kk) 
(logL122 - logL111)./(A22(kk,1)-A11(kk,1) )
Gradln200(1,kk) 
(logL222 - logL211)./(A22(kk,1)-A11(kk,1) )
max(max(abs(gra_old_da_tilda_dA - (ai_tilda_Old_22-ai_tilda_Old_11)./(A22(kk,1)-A11(kk,1)))))
end

if gridsearch_sigmas==1 %This modifies the globals sigma1_stor and sigma2_stor
    run('gradient_search.m')
end


%%%%%
%startMatrix=0.*startMatrix;
%A_bis = round(10000*startMatrix)/10000
%tic
%[minus_loglike,minus_Grad]=ObjectiveFunction_ML(A_bis,BF_A_tilda,BF_G_tilda,w)
%toc

%%%


if estimation==1
tic
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%% ESTIMATION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
N
[Aopti_tilde, minus_Fval, Exitflag, Output,minus_Grad, minus_HessA] = fminunc(@(A) ObjectiveFunction_ML(A,BF_A_tilda,BF_G_tilda,w),startMatrix,options);
%%If one wants a very precise Hessian:
%[Aopti_tilde, minus_Fval, Exitflag] = fminunc(@(A) ObjectiveFunction_ML(A,BF_A_tilda,BF_G_tilda,w),startMatrix,options);
%[HessA,err] = hessian(@(A) ObjectiveFunction_ML(A,BF_A_tilda,BF_G_tilda,w),Aopti_tilde)

%[Aopti, minus_Fval, Exitflag, Output,minus_Grad, HessA] = fminunc(@(A) ObjectiveFunction_ML_NoGrad(A,BF_A_tilda,BF_G_tilda,BF_Gbis,lambdaEx,lambdaFy,tEy,PY,PY_tilda,SPY,w,P,lognorm,maxRank),startMatrix,options);
%[Aopti_NoGrad, minus_Fval_NoGrad, Exitflag, Output,minus_Grad_NoGrad, HessA_NoGrad] = fminunc(@(A) ObjectiveFunction_ML_NoGrad(A,BF_A_tilda,BF_G_tilda,BF_Gbis,lambdaEx,lambdaFy,tEy,PY,PY_tilda,SPY,w,P,lognorm,maxRank),startMatrix,options);
Exitflag
toc
%rescaling because in the coding of objective function we assumed alpha and
%gamma where alpha/sigma and gamma/sigma where sigma = sigma1+sigma2 (see
%scaling section in paper)


Aopti = Aopti_tilde.*(sigma1_stor+sigma2_stor);
year = 2017;

%Save estimation results: Aopti_tilde
filename2=strcat('Outputs/','Estimates_Aopti_tilde_QE_sp',num2str(specification),num2str(year));
xlRange = 'A1';
xlswrite(filename2,Aopti_tilde,1,xlRange);

%Save estimation results: sigma1
filename2=strcat('Outputs/','Estimates_sigma1_stor_QE_sp',num2str(specification),num2str(year));
xlRange = 'A1';
xlswrite(filename2,sigma1_stor,1,xlRange);

%Save estimation results: sigma2
filename2=strcat('Outputs/','Estimates_sigma2_stor_QE_sp',num2str(specification),num2str(year));
xlRange = 'A1';
xlswrite(filename2,sigma2_stor,1,xlRange);



%%%Converting Hession to S.D. /t-stat
FI_A = minus_HessA;
InvFish = inv(FI_A);
VarCov = diag(InvFish);
SD_Aopti = nonzeros((VarCov).^(1/2)).*(sigma1_stor+sigma2_stor);
t_Aopti = Aopti ./ SD_Aopti;

Aopti_tilde./nonzeros((VarCov).^(1/2))

year = 2017;
%Save estimation results: Aopti
filename2=strcat('Outputs/','Estimates_Aopti_QE',num2str(specification),num2str(year));
xlRange = 'A1';
xlswrite(filename2,Aopti,1,xlRange);

%Save estimation results: t_Aopti
filename2=strcat('Outputs/','Estimates_t_Aopti_QE',num2str(specification),num2str(year));
xlRange = 'A1';
xlswrite(filename2,t_Aopti,1,xlRange);

%Save estimation results
filename2=strcat('Outputs/','Estimates_SD_Aopti_QE',num2str(specification),num2str(year));
xlRange = 'A1';
xlswrite(filename2,SD_Aopti,1,xlRange);
end

if estimation==0
    year = 2017;
    filename2=strcat('Outputs/','Estimates_Aopti_tilde_QE_sp',num2str(specification),num2str(year));
    Aopti_tilde=xlsread(filename2);
    
    filename2=strcat('Outputs/','Estimates_sigma1_stor_QE_sp',num2str(specification),num2str(year));
    sigma1_stor=xlsread(filename2);


    filename2=strcat('Outputs/','Estimates_sigma2_stor_QE_sp',num2str(specification),num2str(year));
    sigma2_stor=xlsread(filename2);
    
    
%Save estimation results: Aopti
filename2=strcat('Outputs/','Estimates_Aopti_QE',num2str(specification),num2str(year));
Aopti=xlsread(filename2);


%Save estimation results: t_Aopti
filename2=strcat('Outputs/','Estimates_t_Aopti_QE',num2str(specification),num2str(year));
t_Aopti=xlsread(filename2);

%Save estimation results
filename2=strcat('Outputs/','Estimates_SD_Aopti_QE',num2str(specification),num2str(year));
SD_Aopti=xlsread(filename2);
    
end

[minus_loglike,minus_Grad] = ObjectiveFunction_ML( Aopti_tilde,BF_A_tilda,BF_G_tilda,w)

year = 2017;
%Save estimation results: Aopti
filename2=strcat('Outputs/','LogLikelihood_QE',num2str(specification),num2str(year));
xlRange = 'A1';
xlswrite(filename2,-minus_loglike,1,xlRange);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%PRINT OUTPUTS OF ESTIMATION ON SCREEN%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Calculating the variance of Affinity estimates A and G

%%%%TEMPO
%X_inter_tilda,Y_inter
%X_inter_tilda = X(:,[1 2]);
%Y_inter = Y;
%[N,mx_A]=size(X_inter_tilda);
%[~,my_A]=size(Y_inter);

%Y_inter_tilda,X_inter
%Y_inter_tilda = Y;
%X_inter = X(:,[1 2 5]);
%[N,mx_G]=size(X_inter);
%[~,my_G]=size(Y_inter_tilda);
%%%%%%

[Aa,Ga,t]=ReadParameters(K_A,K_G,Aopti);
[t_Aa,t_Ga,t_t]=ReadParameters(K_A,K_G,t_Aopti);
[SD_Aa,SD_Ga,SD_t]=ReadParameters(K_A,K_G,SD_Aopti);
%[Aa,Ga]=ReadParameters(K_A,K_G,Aopti);
%[t_Aa,t_Ga]=ReadParameters(K_A,K_G,t_Aopti);
%[SD_Aa,SD_Ga]=ReadParameters(K_A,K_G,SD_Aopti);
[ALPHA, FEy]=reshape2(Aa, mx_A,my_A)
[t_ALPHA, t_FEy]=reshape2(t_Aa, mx_A,my_A)
[SD_ALPHA, SD_FEy]=reshape2(SD_Aa, mx_A,my_A);
[GAMMA, FEx]=reshape2(Ga, mx_G,my_G)
[t_GAMMA, t_FEx]=reshape2(t_Ga, mx_G,my_G)
[SD_GAMMA, SD_FEx]=reshape2(SD_Ga, mx_G,my_G);



%%%%%%%%%%%%%Calculating the value of a statistical life in $M %%%%%%%%%%%%
%FEy(1,1) is the disutility (in dollars) of working in a job with 1std more risk
%StdRisk is the additional fatality (death) risk / 1000 if we move 1 std
%above average risk
if logwage==0
    VOSL=-FEy(1,1)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    SD_VOSL=SD_FEy(1,1)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year
    %VOSL_wo=-(FEy(1,1)+ALPHA(3,1))/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
else  
    if specification==2
    VOSL=-(FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    SD_VOSL=(SD_FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year
    %VOSL_wo=-((FEy(1,1)+ALPHA(2,1))*meanW_wo)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    end
    if specification==11
    VOSL=-(FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    SD_VOSL=(SD_FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year
    end

    if specification==13
    VOSL=-(FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    SD_VOSL=(SD_FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year
    VOSL_wo=-((FEy(1,1)+ALPHA(1,1))*meanW_wo)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    end
    if specification==15
    VOSL=-(FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    SD_VOSL=(SD_FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year
    VOSL_wo=-((FEy(1,1)+ALPHA(3,1))*meanW_wo)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    end
    if specification==16
    VOSL=-(FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    SD_VOSL=(SD_FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year
    VOSL_wo=-((FEy(1,1)+ALPHA(3,1))*meanW_wo)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    end
    if specification==10
    VOSL=-(FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    SD_VOSL=(SD_FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year
    %VOSL_wo=-((FEy(1,1)+ALPHA(3,1))*meanW_wo)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    end
    if specification==12
    VOSL=-(FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    SD_VOSL=(SD_FEy(1,1)*meanW)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year
    %VOSL_wo=-((FEy(1,1)+ALPHA(3,1))*meanW_wo)/(StdRisk/100000)*40*50/1000000;%40hours/week, 50weeks/year, expressed in $M
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%THEN CHECKING THE WAGE FIT%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%First we generate the equilibrium matching under observed situation
%Reading Parameters
[~,~,K_A] = size(BF_A_tilda);
[~,N,K_G] = size(BF_G_tilda);
[Aa,Ga,t]=ReadParameters(K_A,K_G,Aopti_tilde);
%[Aa,Ga]=ReadParameters(K_A,K_G,A);

[auxA_tilda,auxG_tilda,auxPHI_tilda] = GenUtilities(N,K_A,K_G,BF_A_tilda,Aa,BF_G_tilda,Ga);
%Computing optimal matching Pi and potentials a and b
hetero_scale_ij = 1;
[Pij,ai_tilda,bj_tilda] = OptimalPi_homo(auxPHI_tilda,hetero_scale_ij);

bj_mat = repmat(bj_tilda',N,1);
ai_mat = repmat(ai_tilda,1,N);

if interactions == 1
    w_hat_mat = sigma1_stor.*(auxG_tilda-bj_mat)+sigma2_stor.*(ai_mat-auxA_tilda)+t*ones(N,N);
else
    sigma_tot = sigma1_stor+sigma2_stor;
    w_hat_mat = sigma_tot.*(auxG_tilda-auxA_tilda)+t*ones(N,N);
end

optimal_pij_obs = Pij;
wage_fit_obs = w_hat_mat;
w_hat = diag(w_hat_mat);

%Calculating R2
if lognorm==0
    fw = w;
    fWA = w_hat;
else
    fw = log(w);
    fWA = log(w_hat);
end
err_model = fw - fWA;
zeross = zeros(N,1);
mean(err_model)
plot(fw,fWA,'ko',fw,fw,'-b')
title('Fitted wages on observed wages')

r_sq = 1 - var(err_model) / var(fw)   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%WRITING THE RESULTS IN TABLES%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%5 revenuesSport % 6 expensesSport 
%Affinity matrices + main effects

%ALPHA_bis = vertcat(FEy',ALPHA);
FEy_bis = FEy';
%SD_ALPHA_bis = vertcat(SD_FEy',SD_ALPHA);
SD_FEy_bis = SD_FEy';

%GAMMA_bis = horzcat(FEx,GAMMA);
FEx_bis = FEx';
[sFEx,~]=size(FEx);
%SD_GAMMA_bis = horzcat(SD_FEx,SD_GAMMA);
SD_FEx_bis = SD_FEx';

mFEy=-FEy(1,1);
%*100;

if specification==11
FID = fopen('Outputs\Coef_Risk_QE11.tex', 'w');
fprintf(FID, '%6.3f', mFEy(1,1));
fclose(FID);

FID = fopen('Outputs\VOSL_QE11.tex', 'w');
fprintf(FID, '%6.1f', VOSL);
fclose(FID);

FID = fopen('Outputs\SDVOSL_QE11.tex', 'w');
fprintf(FID, '%6.1f', SD_VOSL);
fclose(FID);
end

if specification==15
FID = fopen('Outputs\Coef_Risk_QE15.tex', 'w');
fprintf(FID, '%6.3f', mFEy(1,1));
fclose(FID);

FID = fopen('Outputs\VOSL_QE15.tex', 'w');
fprintf(FID, '%6.1f', VOSL);
fclose(FID);

FID = fopen('Outputs\SDVOSL_QE15.tex', 'w');
fprintf(FID, '%6.1f', SD_VOSL);
fclose(FID);

mFEy_fem=(-FEy(1,1)-ALPHA(3,1)); 
FID = fopen('Outputs\Coef_Risk_fem_QE15.tex', 'w');
fprintf(FID, '%6.3f', mFEy_fem(1,1));
fclose(FID);

FID = fopen('Outputs\VOSL_wo_QE15.tex', 'w');
fprintf(FID, '%6.1f', VOSL_wo);
fclose(FID);
end

if specification==16
FID = fopen('Outputs\Coef_Risk_QE16.tex', 'w');
fprintf(FID, '%6.3f', mFEy(1,1));
fclose(FID);

FID = fopen('Outputs\VOSL_QE16.tex', 'w');
fprintf(FID, '%6.1f', VOSL);
fclose(FID);

FID = fopen('Outputs\SDVOSL_QE16.tex', 'w');
fprintf(FID, '%6.1f', SD_VOSL);
fclose(FID);

mFEy_fem=(-FEy(1,1)-ALPHA(3,1)); 
FID = fopen('Outputs\Coef_Risk_fem_QE16.tex', 'w');
fprintf(FID, '%6.3f', mFEy_fem(1,1));
fclose(FID);

FID = fopen('Outputs\VOSL_wo_QE16.tex', 'w');
fprintf(FID, '%6.1f', VOSL_wo);
fclose(FID);
end

if specification==10
FID = fopen('Outputs\Coef_Risk_QE10.tex', 'w');
fprintf(FID, '%6.3f', mFEy(1,1));
fclose(FID);

FID = fopen('Outputs\VOSL_QE10.tex', 'w');
fprintf(FID, '%6.1f', VOSL);
fclose(FID);

FID = fopen('Outputs\SDVOSL_QE10.tex', 'w');
fprintf(FID, '%6.1f', SD_VOSL);
fclose(FID);
end

if specification==12
FID = fopen('Outputs\Coef_Risk_QE12.tex', 'w');
fprintf(FID, '%6.3f', mFEy(1,1));
fclose(FID);

FID = fopen('Outputs\VOSL_QE12.tex', 'w');
fprintf(FID, '%6.1f', VOSL);
fclose(FID);

FID = fopen('Outputs\SDVOSL_QE12.tex', 'w');
fprintf(FID, '%6.1f', SD_VOSL);
fclose(FID);
end

%%%Suggestion: specification 11: only main effects
%%%Then specification 15: lot's of interaction (incl. gender), but since
%%%interaction between risk and X and gender and Y not sig in alpha, kick it out for alpha
%%%Then specification 10: alpha we use only public for y and education, experience and union in X (X1, X2 and X5). For Gamma we use risk and public dummy as Y (Y1 and Y2) and education, experience and union membership (X1, X2 and X5 respectively)
%results : very good results, good sigmas and other coefficients.

if specification==11
    %produce table
rowLabelsa = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','YoS squared','Experience squared (in years)');
rowLabelsb = char('','', '', '','','','','','','');
%rowLabelsa = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','Experience squared (in years)');
%rowLabelsb = char('','', '', '','','','','','');
colLabels_a = char(' Job Amenities (Alpha) &','&','Risk (in 100,000) &','Public');
colLabels_b = char(' &','Main effects &','Risk (in 100,000) &','Public');

FID = fopen('Outputs\MainEffectsTab_QE11.tex', 'w');
%fprintf(FID, ' Job Amenities (Alpha) & &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_a');
for k=1:1
    fprintf(FID, '%s & %s & %6.2f & %6.2f \\\\ \n', rowLabelsa(k,:),'',FEy_bis(k,1:My));
    fprintf(FID, '%s & %s & (%6.2f) & (%6.2f) \\\\ \n', rowLabelsb(k,:),'',SD_FEy_bis(k,1:My));
end

fprintf(FID, '\\hline ');
fprintf(FID, ' Productivity (Gamma) & Main effects &  &  \\\\  \n');
%fprintf(FID, '%s \\\\ \n', colLabels_b');
%fprintf(FID, '%s & %s & %6.2f & %6.2f \\\\ \n', rowLabelsa(1,:),'',FE_prod(1:My,1));
%fprintf(FID, '%s & %s & \\emph{%6.2f} & \\emph{%6.2f} \\\\ \n', rowLabelsb(1,:),'',SD_FE_prod(1:My,1));
for k=1:sFEx
    fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', rowLabelsa(k+1,:),FEx(k,:),'','');
    fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', rowLabelsb(k+1,:),SD_FEx(k,:),'','');
end

fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Salary constant',t,'','');
fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_t,'','');

fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Sigma 1',sigma1_stor,'','');
%fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_sigma1_stor,'','');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Sigma 2',sigma2_stor,'','');
%fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_sigma2_stor,'','');
fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.3f & %s & %s \\\\ \n', 'R-square',r_sq,'','');

fprintf(FID, '\\hline\\hline ');
fprintf(FID, '\n');
%fprintf(FID, '\\end{tabular}\n');
fclose(FID);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end


if specification==15
    %produce tables
rowLabelsa = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','YoS squared','Experience squared (in years)');
rowLabelsb = char('','', '', '','','','','','','');
%rowLabelsa = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','Experience squared (in years)');
%rowLabelsb = char('','', '', '','','','','','');
colLabels_a = char(' Job Amenities (Alpha) &','&','Risk (in 100,000) &','Public');
colLabels_b = char(' &','Main effects &','Risk (in 100,000) &','Public');

FID = fopen('Outputs\MainEffectsTab_QE15.tex', 'w');
%fprintf(FID, ' Job Amenities (Alpha) & &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_a');
for k=1:1
    fprintf(FID, '%s & %s & %6.2f & %6.2f \\\\ \n', rowLabelsa(k,:),'',FEy_bis(k,1:My));
    fprintf(FID, '%s & %s & (%6.2f) & (%6.2f) \\\\ \n', rowLabelsb(k,:),'',SD_FEy_bis(k,1:My));
end

fprintf(FID, '\\hline ');
fprintf(FID, ' Productivity (Gamma) & Main effects &  &  \\\\  \n');
%fprintf(FID, '%s \\\\ \n', colLabels_b');
%fprintf(FID, '%s & %s & %6.2f & %6.2f \\\\ \n', rowLabelsa(1,:),'',FE_prod(1:My,1));
%fprintf(FID, '%s & %s & \\emph{%6.2f} & \\emph{%6.2f} \\\\ \n', rowLabelsb(1,:),'',SD_FE_prod(1:My,1));
for k=1:sFEx
    fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', rowLabelsa(k+1,:),FEx(k,:),'','');
    fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', rowLabelsb(k+1,:),SD_FEx(k,:),'','');
end

fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Salary constant',t,'','');
fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_t,'','');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Sigma 1',sigma1_stor,'','');
%fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_sigma1_stor,'','');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Sigma 2',sigma2_stor,'','');
%fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_sigma2_stor,'','');
fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.3f & %s & %s \\\\ \n', 'R-square',r_sq,'','');

fprintf(FID, '\\hline\\hline ');
fprintf(FID, '\n');
%fprintf(FID, '\\end{tabular}\n');
fclose(FID);


%Affinity matrices
rowLabels_a = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female');
rowLabels_b = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female');
colLabels_a = char(' Job Amenities (Alpha) &','Risk (in 100,000) &','Public');
colLabels_b = char(' Productivity (Gamma) &','Risk (in 100,000) &','Public');

FID = fopen('Outputs\AffinityTab_QE15.tex', 'w');
%fprintf(FID, '\\begin{tabular}{l|rr}\\hline\\hline \n');
%fprintf(FID, ' Job Amenities (Alpha) &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_a');
for k=1:size(rowLabels_a)-1
    fprintf(FID, '%s & %6.2f & %6.2f \\\\ \n', rowLabels_a(k+1,:),ALPHA(k,:));
    fprintf(FID, '%s & (%6.2f) & (%6.2f) \\\\ \n', '',SD_ALPHA(k,:));
end

fprintf(FID, '\\hline ');
%fprintf(FID, ' Productivity (Gamma) &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_b');
for k=1:size(rowLabels_b)-1
    fprintf(FID, '%s & %6.2f & %6.2f \\\\ \n', rowLabels_b(k+1,:),GAMMA(k,:));
    fprintf(FID, '%s & (%6.2f) & (%6.2f) \\\\ \n', '',SD_GAMMA(k,:));
end

fprintf(FID, '\\hline\\hline ');
fprintf(FID, '\n');
%fprintf(FID, '\\end{tabular}\n');
fclose(FID);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end

%%%
if specification==16
    %produce tables
%rowLabelsa = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','YoS squared','Experience squared (in years)');
%rowLabelsb = char('','', '', '','','','','','','');
rowLabelsa = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','Experience squared (in years)');
rowLabelsb = char('','', '', '','','','','','');
colLabels_a = char(' Job Amenities (Alpha) &','&','Risk (in 100,000) &','Public');
colLabels_b = char(' &','Main effects &','Risk (in 100,000) &','Public');

FID = fopen('Outputs\MainEffectsTab_QE16.tex', 'w');
%fprintf(FID, ' Job Amenities (Alpha) & &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_a');
for k=1:1
    fprintf(FID, '%s & %s & %6.2f & %6.2f \\\\ \n', rowLabelsa(k,:),'',FEy_bis(k,1:My));
    fprintf(FID, '%s & %s & (%6.2f) & (%6.2f) \\\\ \n', rowLabelsb(k,:),'',SD_FEy_bis(k,1:My));
end

fprintf(FID, '\\hline ');
fprintf(FID, ' Productivity (Gamma) & Main effects &  &  \\\\  \n');
%fprintf(FID, '%s \\\\ \n', colLabels_b');
%fprintf(FID, '%s & %s & %6.2f & %6.2f \\\\ \n', rowLabelsa(1,:),'',FE_prod(1:My,1));
%fprintf(FID, '%s & %s & \\emph{%6.2f} & \\emph{%6.2f} \\\\ \n', rowLabelsb(1,:),'',SD_FE_prod(1:My,1));
for k=1:sFEx
    fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', rowLabelsa(k+1,:),FEx(k,:),'','');
    fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', rowLabelsb(k+1,:),SD_FEx(k,:),'','');
end

fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Salary constant',t,'','');
fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_t,'','');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Sigma 1',sigma1_stor,'','');
%fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_sigma1_stor,'','');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Sigma 2',sigma2_stor,'','');
%fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_sigma2_stor,'','');
fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.3f & %s & %s \\\\ \n', 'R-square',r_sq,'','');

fprintf(FID, '\\hline\\hline ');
fprintf(FID, '\n');
%fprintf(FID, '\\end{tabular}\n');
fclose(FID);


%Affinity matrices
rowLabels_a = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female');
rowLabels_b = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female');
colLabels_a = char(' Job Amenities (Alpha) &','Risk (in 100,000) &','Public');
colLabels_b = char(' Productivity (Gamma) &','Risk (in 100,000) &','Public');

FID = fopen('Outputs\AffinityTab_QE16.tex', 'w');
%fprintf(FID, '\\begin{tabular}{l|rr}\\hline\\hline \n');
%fprintf(FID, ' Job Amenities (Alpha) &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_a');
for k=1:size(rowLabels_a)-1
    fprintf(FID, '%s & %6.2f & %6.2f \\\\ \n', rowLabels_a(k+1,:),ALPHA(k,:));
    fprintf(FID, '%s & (%6.2f) & (%6.2f) \\\\ \n', '',SD_ALPHA(k,:));
end

fprintf(FID, '\\hline ');
%fprintf(FID, ' Productivity (Gamma) &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_b');
for k=1:size(rowLabels_b)-1
    fprintf(FID, '%s & %6.2f & %6.2f \\\\ \n', rowLabels_b(k+1,:),GAMMA(k,:));
    fprintf(FID, '%s & (%6.2f) & (%6.2f) \\\\ \n', '',SD_GAMMA(k,:));
end

fprintf(FID, '\\hline\\hline ');
fprintf(FID, '\n');
%fprintf(FID, '\\end{tabular}\n');
fclose(FID);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end


if specification==10
    %produce table
%rowLabelsa = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','YoS squared','Experience squared (in years)');
%rowLabelsb = char('','', '', '','','','','','','');
rowLabels_alpha_a = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female');
rowLabels_alpha_b = char('','', '', '');
rowLabels_gamma_a = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','Experience squared (in years)');
rowLabels_gamma_b = char('','', '', '','','','','','');
colLabels_a = char(' Job Amenities (Alpha) &','Main effects &','Risk (in 100,000) &','Public');
colLabels_b = char(' &','Main effects &','Risk (in 100,000) &','Public');

FID = fopen('Outputs\MainEffectsTab_QE10.tex', 'w');
%fprintf(FID, ' Job Amenities (Alpha) & &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_a');
for k=1:1
    fprintf(FID, '%s & %s & %6.3f & %6.3f \\\\ \n', rowLabels_alpha_a(k,:),'',FEy_bis(k,1:My));
    fprintf(FID, '%s & %s & (%6.3f) & (%6.3f) \\\\ \n', rowLabels_alpha_b(k,:),'',SD_FEy_bis(k,1:My));
end
    fprintf(FID, '%s & %6.3f & %6.3f & %6.3f \\\\ \n', rowLabels_alpha_a(2,:),'','',ALPHA(1,:));
    fprintf(FID, '%s & %6.3f & %6.3f & (%6.3f) \\\\ \n', '','','',SD_ALPHA(1,:));
%for k=3:size(rowLabels_alpha_a)
%    fprintf(FID, '%s & %6.2f & %6.2f & %6.2f \\\\ \n', rowLabels_alpha_a(k,:),'','','');
%    fprintf(FID, '%s & %6.2f & %6.2f & %6.2f \\\\ \n', '','','','');
%end

fprintf(FID, '\\hline ');
fprintf(FID, ' Productivity (Gamma) & Main effects & Risk (in 100,000) & Public  \\\\  \n');
%fprintf(FID, '%s \\\\ \n', colLabels_b');
%fprintf(FID, '%s & %s & %6.2f & %6.2f \\\\ \n', rowLabelsa(1,:),'',FE_prod(1:My,1));
%fprintf(FID, '%s & %s & \\emph{%6.2f} & \\emph{%6.2f} \\\\ \n', rowLabelsb(1,:),'',SD_FE_prod(1:My,1));
%'Main effects','YoS (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','Experience squared (in years)');
for k=1:3
    fprintf(FID, '%s & %6.3f & %6.3f & %6.3f  \\\\ \n', rowLabels_gamma_a(k+1,:),FEx(k,:),GAMMA(k,:));
    fprintf(FID, '%s & (%6.3f) & (%6.3f) & (%6.3f) \\\\ \n', rowLabels_gamma_b(k+1,:),SD_FEx(k,:),SD_GAMMA(k,:));
end
for k=4:sFEx
    fprintf(FID, '%s & %6.3f & %s & %s \\\\ \n', rowLabels_gamma_a(k+1,:),FEx(k,:),'','');
    fprintf(FID, '%s & (%6.3f) & %s & %s \\\\ \n', rowLabels_gamma_b(k+1,:),SD_FEx(k,:),'','');
end


fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.3f & %s & %s \\\\ \n', 'Salary constant',t,'','');
fprintf(FID, '%s & (%6.3f) & %s & %s \\\\ \n', '',SD_t,'','');
fprintf(FID, '%s & %6.3f & %s & %s \\\\ \n', 'Sigma 1',sigma1_stor,'','');
%fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_sigma1_stor,'','');
fprintf(FID, '%s & %6.3f & %s & %s \\\\ \n', 'Sigma 2',sigma2_stor,'','');
%fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_sigma2_stor,'','');
fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.3f & %s & %s \\\\ \n', 'R-square',r_sq,'','');

fprintf(FID, '\\hline\\hline ');
fprintf(FID, '\n');
%fprintf(FID, '\\end{tabular}\n');
fclose(FID);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end

if specification==12
%produce table
rowLabelsa = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','YoS squared','Experience squared (in years)');
rowLabelsb = char('','', '', '','','','','','','');
%rowLabelsa = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','Experience squared (in years)');
%rowLabelsb = char('','', '', '','','','','','');
colLabels_a = char(' Job Amenities (Alpha) &','&','Risk (in 100,000) &','Public');
colLabels_b = char(' &','Main effects &','Risk (in 100,000) &','Public');

FID = fopen('Outputs\MainEffectsTab_QE12.tex', 'w');
%fprintf(FID, ' Job Amenities (Alpha) & &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_a');
for k=1:1
    fprintf(FID, '%s & %s & %6.2f & %6.2f \\\\ \n', rowLabelsa(k,:),'',FEy_bis(k,1:My));
    fprintf(FID, '%s & %s & (%6.2f) & (%6.2f) \\\\ \n', rowLabelsb(k,:),'',SD_FEy_bis(k,1:My));
end

fprintf(FID, '\\hline ');
fprintf(FID, ' Productivity (Gamma) & Main effects &  &  \\\\  \n');
%fprintf(FID, '%s \\\\ \n', colLabels_b');
%fprintf(FID, '%s & %s & %6.2f & %6.2f \\\\ \n', rowLabelsa(1,:),'',FE_prod(1:My,1));
%fprintf(FID, '%s & %s & \\emph{%6.2f} & \\emph{%6.2f} \\\\ \n', rowLabelsb(1,:),'',SD_FE_prod(1:My,1));
for k=1:sFEx
    fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', rowLabelsa(k+1,:),FEx(k,:),'','');
    fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', rowLabelsb(k+1,:),SD_FEx(k,:),'','');
end

fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Salary constant',t,'','');
fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_t,'','');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Sigma 1',sigma1_stor,'','');
%fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_sigma1_stor,'','');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Sigma 2',sigma2_stor,'','');
%fprintf(FID, '%s & (%6.2f) & %s & %s \\\\ \n', '',SD_sigma2_stor,'','');
fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.3f & %s & %s \\\\ \n', 'R-square',r_sq,'','');

fprintf(FID, '\\hline\\hline ');
fprintf(FID, '\n');
%fprintf(FID, '\\end{tabular}\n');
fclose(FID);


%5 revenuesSport % 6 expensesSport 
%Affinity matrices
rowLabels_a = char('Main effects','YoS (in years)');
rowLabels_b = char('Main effects','YoS (in years)', 'Experience (in years)', 'Female');
colLabels_a = char(' Job Amenities (Alpha) &','Risk (in 100,000) &','Public');
colLabels_b = char(' Productivity (Gamma) &','Risk (in 100,000) &','Public');

FID = fopen('Outputs\AffinityTab_QE12.tex', 'w');
%fprintf(FID, '\\begin{tabular}{l|rr}\\hline\\hline \n');
%fprintf(FID, ' Job Amenities (Alpha) &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_a');
for k=1:size(rowLabels_a)-1
    fprintf(FID, '%s & %6.2f & %6.2f \\\\ \n', rowLabels_a(k+1,:),'',ALPHA(k,:));
    fprintf(FID, '%s & (%6.2f) & (%6.2f) \\\\ \n', '','',SD_ALPHA(k,:));
end

fprintf(FID, '\\hline ');
%fprintf(FID, ' Productivity (Gamma) &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_b');
for k=1:size(rowLabels_b)-1
    fprintf(FID, '%s & %6.2f & %6.2f \\\\ \n', rowLabels_b(k+1,:),GAMMA(k,:));
    fprintf(FID, '%s & (%6.2f) & (%6.2f) \\\\ \n', '',SD_GAMMA(k,:));
end

fprintf(FID, '\\hline\\hline ');
fprintf(FID, '\n');
%fprintf(FID, '\\end{tabular}\n');
fclose(FID);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%SIMULATION%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%idea of simulation is to mimick a government intervention imposing jobs to
%be safer than 2 standard dev. All jobs with risk above 2 std are replaced
%by jobs with 2 std risk.

%First we have generated the equilibrium corresponding to the observed
%situation above

%Second we change the most risky jobs into less risky jobs, all jobs with
%risk 1 std above mean
Ybis = Y;
Index = Ybis(:,1)>=1;
Ybis(Index,1)=1;

horzcat(Ybis(Index,1),Y(Index,1))
[N_changed,~] = size(Y(Index,1));
[N,~]=size(Y(:,1));
Perc_job_affected = N_changed/N*100

if same_order == 0 
     PYbis=poly_terms(Ybis, Oy_vec);
else
     PYbis=poly_terms(Ybis, Oy);
end

[BF_A_tilda_bis,BF_G_tilda_bis] = GenBFTilde_QE(X,PX,Ybis,PYbis);

[~,~,K_A] = size(BF_A_tilda_bis);
[~,N,K_G] = size(BF_G_tilda_bis);
[Aa,Ga,t]=ReadParameters(K_A,K_G,Aopti_tilde);
%[Aa,Ga]=ReadParameters(K_A,K_G,A);

[auxA_tilda,auxG_tilda,auxPHI_tilda] = GenUtilities(N,K_A,K_G,BF_A_tilda_bis,Aa,BF_G_tilda_bis,Ga);
%Computing optimal matching Pi and potentials a and b
hetero_scale_ij = 1;
[Pij,ai_tilda,bj_tilda] = OptimalPi_homo(auxPHI_tilda,hetero_scale_ij);

bj_mat = repmat(bj_tilda',N,1);
ai_mat = repmat(ai_tilda,1,N);

if interactions == 1
    w_hat_mat = sigma1_stor.*(auxG_tilda-bj_mat)+sigma2_stor.*(ai_mat-auxA_tilda)+t*ones(N,N);
else
    sigma_tot = sigma1_stor+sigma2_stor;
    w_hat_mat = sigma_tot.*(auxG_tilda-auxA_tilda)+t*ones(N,N);
end

optimal_pij_sim = Pij;
wage_fit_sim = w_hat_mat;

mean_wage_i_obs = mean( exp(wage_fit_obs).*optimal_pij_obs, 2);
mean_wage_i_sim = mean( exp(wage_fit_sim).*optimal_pij_sim , 2);

percent_change_wage = (mean_wage_i_sim-mean_wage_i_obs)*100;
percent_change_wage(Index)
%%%%%
Mean_OBS_fit_wage = mean(exp(diag(wage_fit_obs)))
Mean_obs = mean(mean_wage_i_obs)
Mean_sim = mean(mean_wage_i_sim)
Variance_obs = var(mean_wage_i_obs)
Variance_sim = var(mean_wage_i_sim)
gini_obs = sum(sum(abs(repmat(mean_wage_i_obs,1,N)-repmat(mean_wage_i_obs',N,1))))/(2*N^2*Mean_obs)
gini_sim = sum(sum(abs(repmat(mean_wage_i_sim,1,N)-repmat(mean_wage_i_sim',N,1))))/(2*N^2*Mean_sim)

perc_change_mean = (Mean_sim - Mean_obs)/Mean_obs*100
perc_change_var = (Variance_sim - Variance_obs)/Variance_obs*100
perc_change_gini = (gini_sim - gini_obs)/gini_obs*100

reallocation = sum(sum(abs(optimal_pij_sim-optimal_pij_obs)))
perc_realloc = reallocation/N*100


%Regression of Pij on X, PX and Y
%W = reshape(optimal_pij_obs,N*N,1);
%Zre = zeros(N*N,10);
%Zre(:,1) = reshape(repmat(Y(:,1)',N,1),N*N,1);
%Zre(:,2) = reshape(repmat(Y(:,2)',N,1),N*N,1);
%for i = 3:10
%    k=i-2;
%    Zre(:,i) = reshape(repmat(X(:,k),1,N),N*N,1);
%end

%beta = (Zre'*Zre)\(Zre'*W)
%res = W - Zre*beta;
%s2 = (res'*res)./(N*N-10);
%se = diag((s2 .* inv(Zre'*Zre) ).^0.5)

%beta./se %be careful, we should use cluster standard errors since we have repeated information, each worker appears N times in the sample.

%histo = histogram2(Y(:,1),X(:,1))


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



stop


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%SIMULATION%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%idea of simulation is to mimick a government intervention imposing jobs to
%be safer than 2 standard dev. All jobs with risk above 2 std are replaced
%by jobs with 2 std risk.

%First we generate the equilibrium matching under observed situation
[minus_loglike,minus_Grad] = ObjectiveFunction_ML(Aopti_tilde,BF_A_tilda,BF_G_tilda,w);
optimal_pij_obs = Pij_Old;
wage_fit_obs = w_hat;

%Second we change the most risky jobs into less risky jobs
Ybis = Y;
Index = Ybis(:,1)>=2;
Ybis(Index,1)=2;

horzcat(Ybis(Index,1),Y(Index,1))
[N_changed,~] = size(Y(Index,1));
[N,~]=size(Y(:,1));
Perc_job_affected = N_changed/N*100

if same_order == 0 
     PYbis=poly_terms(Ybis, Oy_vec);
else
     PYbis=poly_terms(Ybis, Oy);
end
[BF_A_tilda_bis,BF_G_tilda_bis] = GenBFTilde_QE(X,PX,Ybis,PYbis);
[minus_loglike,minus_Grad] = ObjectiveFunction_ML(Aopti,BF_A_tilda_bis,BF_G_tilda_bis,w);
optimal_pij_sim = Pij_Old;
wage_fit_sim = w_hat;

percent_change_wage = (wage_fit_sim-wage_fit_obs)*100
percent_change_wage(Index)
%%%%%

prob_diag_fit_obs = ones(N,1)
prob_diag_fit_sim = ones(N,1)

Mean_obs = mean(exp(wage_fit_obs).*prob_diag_fit_obs)
Mean_sim = mean(exp(wage_fit_sim).*prob_diag_fit_sim)
Variance_obs = var(exp(wage_fit_obs).*prob_diag_fit_obs)
Variance_sim = var(exp(wage_fit_sim).*prob_diag_fit_sim)

diff_mean = Mean_obs - Mean_sim
diff_var = Variance_obs - Variance_sim

max(max(abs(optimal_pij_sim-optimal_pij_obs)))

stop































stop



%%%%%%%%%%%%%%%%%%%%%%%%%%%SIMULATION%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     
     
%%%%%%%%%%%%%%%%%%%%%%%% Linear Taxes 
utrue=(-log(Ai_base)+t_stor).*(1-tEx)+tEx*t_k(end);% ok: u = u_tilda / lambdaEx; but why the term tEx*t_k(end)?
vtrue=(-log(Bj_base)-t_stor).*(1+tFy)./(1-tEy);% ok: v = v_tilda / lambdaFy
%Federal TaX
    f_incr=.01;
    ntax=ceil(max(tEy)/f_incr)+1;   
    tax=f_incr*repmat([0:ntax-1],N,1);%vector containing tax values from 0 to maxtax => x-axis in graphs
    [w_f, SW_f, rev_f, drev_f ,Pis_f, flag_f]= Tax_Sim(1, Aa, Ga,utrue, vtrue,tEy,tax,tFy,X,PX,Y,PY,AM);
    %zero other taxes
    [w_f0, SW_f0, rev_f0, drev_f0 , Pis_0, flag_f0]= Tax_Sim(1, Aa, Ga,utrue, vtrue,zeros(N,1),tax,zeros(N,1),X,PX,Y,PY,AM);
    %equalized other taxes
    tEy_eq=ones(N,1)*mean(tEy);
    tFy_eq=ones(N,1)*mean(tFy);
    [~, SW_feq, rev_feq, ~ , ~, flag_feq]= Tax_Sim(1, Aa, Ga,utrue, vtrue,tEy_eq,tax,tFy_eq,X,PX,Y,PY,AM);
%State Taxes
    st_incr=.001;
    nstate=ceil(mean(tEy)/st_incr)+1;
    tax_state=st_incr*tEy/mean(tEy)*[0:nstate-1];
    [w_s, SW_st, rev_st, drev_st ,Pis_st, flag]= Tax_Sim(0, Aa, Ga,utrue, vtrue,tax_state,tEx,tFy,X,PX,Y,PY,AM);
    [w_s0, SW_st0, rev_st0, drev_st0 ,Pis_st0, flag0]= Tax_Sim(0, Aa, Ga,utrue, vtrue,tax_state,zeros(N,1),zeros(N,1),X,PX,Y,PY,AM);
    maxState=mean(tEy);
    %Equalized state taxes
    tax_state_eq=st_incr *repmat([0:nstate-1],N,1);
    [w_seq, SW_steq, rev_steq, drev_steq ,Pis_steq, flageq]= Tax_Sim(0, Aa, Ga,utrue, vtrue,tax_state_eq,tEx,tFy,X,PX,Y,PY,AM);
save('Outputs/linear_sim') 


%Match changes 
[dPi_f, dPi_f_T, dPi_f_x, dPi_f_xT, dPi_f_y, dPi_f_yT]=absolute_differences(Pis_f); 
[dPi_s, dPi_s_T, dPi_s_x, dPi_s_xT, dPi_s_y, dPi_s_yT]=absolute_differences(Pis_st); 
[dPi_seq, dPi_seq_T, dPi_seq_x, dPi_seq_xT, dPi_seq_y, dPi_seq_yT]=absolute_differences(Pis_steq); 

%Welfare changes
welf=@(sw,drev,incr) [sw(2:end,:)-sw(1:end-1,:),drev(2:end,:,1)]./incr 
dwl_error=@(welf) (welf(:,1)-welf(:,7))./welf(:,1)*100
relative=@(x) x-x(1)

dWelfare_f=welf(SW_f, drev_f,f_incr);
    dwl_error_f=dwl_error(dWelfare_f);
dWelfare_f0=welf(SW_f0, drev_f0,f_incr);
    dwl_error_f0=dwl_error(dWelfare_f0);
dWelfare_st=welf(SW_st, drev_st,st_incr);
    dwl_error_st=dwl_error(dWelfare_st);
dWelfare_steq=welf(SW_steq, drev_steq,st_incr);

t_level=2;
    SW_delta_st=relative(SW_st(:,1));
    rev_delta_st=relative(rev_st(:,t_level));
    SW_delta_steq=relative(SW_steq(:,1));
    rev_delta_steq=relative(rev_steq(:,t_level));
 %   dWelfare_fT=[SW_f(2:end,:)-repmat(SW_f(1,:),ntax-1,1), cumsum(drev_f(2:end,:,1))];
    
    
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%NonLinear Taxes IPFP:%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%CHECKING%%%
targetu=((-log(Ai_base)+t_stor)./lambdaEx); % = mean(ai./lambdaEx)+t_stor*mean(1./lambdEx)
targetv=((-log(Bj_base)-t_stor)./lambdaFy);
targeta=mean(exp(-targetu)); % = mean(ai./lambdaEx)+t_stor*mean(1./lambdEx)
targetb=mean(exp(-targetv));

[ Pij_check,ui_check,vj_check,wage_ij_check,tax_bracket_ij_check ] = Gen_P_u_v_NLTaxes(targeta,1,X,PX,Y,PY,AM,t_k,repmat(.4195, N,7),tEy,tFy,Aopti,SPY);
    [post_tax_wage_check,tax_rev_check]=post_tax(WA,t_k,repmat(.4195, N,7),tEy,tFy);
    rev_check=sum(sum((tax_rev_check.*Pij_check*N)))
    sw_check=sum(ui_check)+sum(vj_check)+rev_check
%[ Pij_sim,ui_sim,vj_sim,wage_ij_sim,tax_bracket_ij_sim ] = Gen_P_u_v_NLTaxes(targeta,1,X,PX,Y,PY,AM,t_k,tEx_k,tEy,tFy,Aopti,SPY);%When normalizing ui's = teams have all BP
[ Pij_sim2,ui_sim2,vj_sim2,wage_ij_sim2,tax_bracket_ij_sim2 ] = Gen_P_u_v_NLTaxes(targetb,0,X,PX,Y,PY,AM,t_k,tEx_k,tEy,tFy,Aopti,SPY);%when normalizing vj's = coaches have all BP

[post_tax_wage_NL,~, tax_rev_NL]=post_tax(wage_ij_sim2,t_k,tEx_k,tEy,tFy);
    revenue_NL=sum(sum((tax_rev_NL.*Pij_sim2*N)))
    sw_NL=sum(ui_sim2)+sum(vj_sim2)+revenue_NL %-sigma1_stor*log(N)-sigma2_stor*log(N)
NLtargeta=mean(exp(-ui_sim2));%Shouldn't this be ui_sim? and not ui_sim2. => in Tax_SimNL, we use NLtargeta for simulation when AinotBj = 1
NLtargetb=mean(exp(-vj_sim2));%Here ok, => in Tax_SimNL, we use NLtargetb for simulation when AinotBj = 0
[ Pij_test,ui_test,vj_test,wage_ij_test,tax_bracket_ij_test ] = Gen_P_u_v_NLTaxes(NLtargeta,1,X,PX,Y,PY,AM,t_k,tEx_k,tEy,tFy,Aopti,SPY);%when normalizing vj's = coaches have all BP


%Changing inframarginal rates   
[~,nk]=size(tEx_k);
nsimNL=42
%tmax_infra=.4195
    mult=reshape([0:nsimNL-1],1,1,nsimNL)*.01; %/nsimNL*tmax_infra
    tEx_array=repmat(mult,N,nk);
    tEx_array(:,end,:)=repmat(tEx_k(:,end),1,1,nsimNL);
[sw_infra,rev_infra]= Tax_SimNL(NLtargeta, NLtargetb, repmat(t_k,nsimNL,1),tEx_array, tEy, tFy,Aopti, SPY, X,PX,Y,PY,AM,auxA,auxG)
[sw_infra0,rev_infra0,neg_infra0]= Tax_SimNL(NLtargeta, NLtargetb, repmat(t_k,nsimNL,1),tEx_array, zeros(N,1), tFy,Aopti, SPY, X,PX,Y,PY,AM,auxA,auxG)
[sw_infra_eq,rev_infra_eq]= Tax_SimNL(NLtargeta, NLtargetb, repmat(t_k,nsimNL,1),tEx_array, repmat(mean(tEy),N,1), tFy,Aopti, SPY, X,PX,Y,PY,AM,auxA,auxG)

%%%%%%%%%%%%%%Adjusting thresholds 
n_thr=40
    t_k_thr=t_k(end)/2+([0:n_thr-1]')*.01;
    t_k_sim=min(repmat(t_k(1:end-2),n_thr,1),repmat(t_k_thr,1,nk-2));
    t_k_sim=[t_k_sim, t_k_thr];
[sw_thr,rev_thr]= Tax_SimNL(NLtargeta, NLtargetb, t_k_sim, repmat(tEx_k(:,[1:5,7]),1,1,n_thr), tEy, tFy,Aopti, SPY, X,PX,Y,PY,AM,auxA,auxG)   
[sw_thr0,rev_thr0]= Tax_SimNL(NLtargeta, NLtargetb, t_k_sim, repmat(tEx_k,1,1,n_thr), zeros(N,1), tFy,Aopti, SPY, X,PX,Y,PY,AM,auxA,auxG)   
[sw_thr_eq,rev_thr_eq]= Tax_SimNL(NLtargeta, NLtargetb, t_k_sim, repmat(tEx_k,1,1,n_thr),  repmat(mean(tEy),N,1), tFy,Aopti, SPY, X,PX,Y,PY,AM,auxA,auxG)   

save('Outputs/NL_sim');





%GIVE THE VALUE OF THE TAXES YOU WANT TO USE FOR THE SIMULATION IN tEx_s,tEy_s, tFy_s
fac = 1;
tEx_s = fac*tEx;
tEy_s = fac*tEy;
tFy_s = fac*tFy;

    


[Pi_s,WA_s] = Simualtion_Pi_Transfer(N,K_A,K_G,Aopti,SPY,tEx_s,tEy_s,tFy_s,X,PX,Y,PY,PY_tilda,AM);
[neg_wages_s] = NegWages(WA_s,Pi_s);
%%write data
varia = {'cum_neg_wages' 'counts_neg_wages'};
data_neg_wages_s = neg_wages_s

sheet = 1;
xlRange = 'A1';
xlswrite('data_negative_wages_simulation',varia,sheet,xlRange);
xlRange = 'A2';
xlswrite('data_negative_wages_simulation',data_neg_wages_s,sheet,xlRange);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%WRITING THE RESULTS IN TABLES%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%5 revenuesSport % 6 expensesSport 
%Affinity matrices + main effects

ALPHA_bis = vertcat(FEy',ALPHA);
SD_ALPHA_bis = vertcat(SD_FEy',SD_ALPHA);


GAMMA_bis = horzcat(FEx,GAMMA);
SD_GAMMA_bis = horzcat(SD_FEx,SD_GAMMA);

rowLabelsa = char('Main effects','Age (in years)', 'Experience (\# of games)', 'Ability (wins/game)');
rowLabelsb = char('','', '', '');
colLabels_a = char(' &','Main effects &','Revenues from sports (in \$M) &','Operating expenses (in \$M)');
colLabels_b = char(' &','Main effects &','Revenues from sports (in \$M) &','Operating expenses (in \$M)');

FID = fopen('C:\Users\arnaud.dupuy\Dropbox\ITU\Application\Tables\TableAllInOne_try.tex', 'w');
%FID = fopen('Tables\TableAllInOne.tex', 'w');
%fprintf(FID, '\\begin{tabular}{l|rrr}\\hline\\hline \n');
fprintf(FID, ' Job Amenities (Alpha) & &  &  \\\\  \n');
%fprintf(FID, '%s \\\\ \n', colLabels_a');
for k=1:Mx+1
    fprintf(FID, '%s & %s & %6.2f & %6.2f \\\\ \n', rowLabelsa(k,:),'',ALPHA_bis(k,1:My));
    fprintf(FID, '%s & %s & {%1.2f} & \\emph{%6.2f} \\\\ \n', rowLabelsb(k,:),'',SD_ALPHA_bis(k,1:My));
end
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Alma Mater',ALPHA_AM,'','');
fprintf(FID, '%s & {%1.2f} & %s & %s \\\\ \n', '',SD_ALPHA_AM,'','');

fprintf(FID, '\\hline ');
fprintf(FID, ' Productivity (Gamma) & &  &  \\\\  \n');
%fprintf(FID, '%s \\\\ \n', colLabels_b');
fprintf(FID, '%s & %s & %6.2f & %6.2f \\\\ \n', rowLabelsa(1,:),'',FE_prod(1:My,1));
fprintf(FID, '%s & %s & \\emph{%6.2f} & \\emph{%6.2f} \\\\ \n', rowLabelsb(1,:),'',SD_FE_prod(1:My,1));
for k=1:Mx
    fprintf(FID, '%s & %6.2f & %6.2f & %6.2f \\\\ \n', rowLabelsa(k+1,:),GAMMA_bis(k,:));
    fprintf(FID, '%s & \\emph{%6.2f} & \\emph{%6.2f} & \\emph{%6.2f} \\\\ \n', rowLabelsb(k+1,:),SD_GAMMA_bis(k,:));
end
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Alma Mater',GAMMA_AM,'','');
fprintf(FID, '%s & \\emph{%6.2f} & %s & %s \\\\ \n', '',SD_GAMMA_AM,'','');

fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Scaling performance',weig,'','');
fprintf(FID, '%s & \\emph{%6.2f} & %s & %s \\\\ \n', '',SD_weig,'','');

fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.2f & %s & %s \\\\ \n', 'Salary constant',t,'','');
fprintf(FID, '%s & \\emph{%6.2f} & %s & %s \\\\ \n', '',SD_t,'','');

fprintf(FID, '\\hline\\hline ');
fprintf(FID, '\n');
%fprintf(FID, '\\end{tabular}\n');
fclose(FID);


%5 revenuesSport % 6 expensesSport 
%Affinity matrices
rowLabels = char('Age (in years)', 'Experience (\$# of games as head coach)', 'Ability (wins/games as head coach)');
colLabels_a = char(' &','Revenues from sports (in \$M) &','Operating expenses (in \$M)');
colLabels_b = char(' &','Revenues from sports (in \$M) &','Operating expenses (in \$M)');

FID = fopen('C:\Users\arnaud.dupuy\Dropbox\ITU\Application\Tables\test.tex', 'w');
FID = fopen('Tables\test.tex', 'w');
fprintf(FID, '\\begin{tabular}{l|rr}\\hline\\hline \n');
fprintf(FID, ' Job Amenities (Alpha) &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_a');
for k=1:Mx
    fprintf(FID, '%s & %6.2f & %6.2f \\\\ \n', rowLabels(k,:),ALPHA(k,:));
    fprintf(FID, '%s & (%6.3f) & (%6.3f) \\\\ \n', '',SD_ALPHA(k,:));
end
fprintf(FID, '%s & %6.2f & %s \\\\ \n', 'Alma Mater',ALPHA_AM,'');
fprintf(FID, '%s & (%6.3f) & %s \\\\ \n', '',SD_ALPHA_AM,'');

fprintf(FID, '\\hline ');
fprintf(FID, ' Productivity (Gamma) &  &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels_b');
for k=1:Mx
    fprintf(FID, '%s & %6.2f & %6.2f \\\\ \n', rowLabels(k,:),GAMMA(k,:));
    fprintf(FID, '%s & (%1.3f) & (%6.3f) \\\\ \n', '',SD_GAMMA(k,:));
end
fprintf(FID, '%s & %6.2f & %s \\\\ \n', 'Alma Mater',GAMMA_AM,'');
fprintf(FID, '%s & (%6.3f) & %s \\\\ \n', '',SD_GAMMA_AM,'');

fprintf(FID, '\\hline\\hline ');
fprintf(FID, '\n');
fprintf(FID, '\\end{tabular}\n');
fclose(FID);

Ox_vec = [1 1 1];
%Oy_vec must be of size (My)
Oy_vec = [1 1];
%Wage regression
FEx_p = FEx';
t_FEx_p = t_FEx';
SD_FEx_p = SD_FEx';
FEy_p = FEy';
t_FEy_p = t_FEy';
SD_FEy_p = SD_FEy';
FE_prod_p = FE_prod';
t_FE_prod_p = t_FE_prod';
SD_FE_prod_p = SD_FE_prod';
poly_order = [1:max(max(Ox_vec),max(Oy_vec))];
colLabels2 = char('Polynomial Order of &','Revenues from sports (in \$M) &','Operating expenses (in \$M) &','');
colLabels1 = char('Polynomial Order of &','Age (in years) &', 'Experience (\$# of games as head coach) &', 'Ability (wins/games as head coach)');
FID = fopen('C:\Users\arnaud.dupuy\Dropbox\ITU\Application\TableDirectEffects.tex', 'w');
fprintf(FID, '\\begin{tabular}{l|rrr}\\hline\\hline \n');
fprintf(FID, ' Job Amenities (Alpha) &  & &  \\\\  \n');
fprintf(FID, '%s \\\\ \n', colLabels2');
for k=1:max(Oy_vec)
    fprintf(FID, '%6.0f & %6.2f & %6.2f & \\\\ \n', poly_order(k),FEy_p(k,:));
    fprintf(FID, '%s & (%6.3f) & (%6.3f) & \\\\ \n', '',SD_FEy_p(k,:));

end
fprintf(FID, '\\hline ');
fprintf(FID, ' Productivity (Gamma) &  & &  \\\\  \n');
fprintf(FID,  '%s  \\\\ \n',colLabels1');
for k=1:max(Ox_vec)
    fprintf(FID, '%6.0f & %6.2f & %6.2f & %6.2f  \\\\ \n', poly_order(k),FEx_p(k,:));
    fprintf(FID, '%s & (%6.3f) & (%6.3f) & (%6.3f) \\\\ \n', '',SD_FEx_p(k,:));
end
fprintf(FID, '%s \\\\ \n', colLabels2');
fprintf(FID, '%6.0f & %6.2f & %6.2f & \\\\ \n', poly_order(1),FE_prod_p);
fprintf(FID, '%s & (%6.3f) & (%6.3f) & \\\\ \n', '',SD_FE_prod_p);
fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.2f & & \\\\ \n', 'Scaling performance',weig);
fprintf(FID, '%s & (%6.3f) & & \\\\ \n', '',SD_weig);
fprintf(FID, '\\hline ');
fprintf(FID, '%s & %6.2f & & \\\\ \n', 'Salary constant',t);
fprintf(FID, '%s & (%6.3f) & & \\\\ \n', '',SD_t);

fprintf(FID, '\\hline\\hline ');
fprintf(FID, '\n');
fprintf(FID, '\\end{tabular}\n');
fclose(FID);

%Performance regression
%FE_prod_p = FE_prod';
%t_FE_prod_p = t_FE_prod';
%colLabels2 = char('Direct effects of: &','Sport Revenues (in \$M) &','\#of undergraduates &','');
%FID = fopen('C:\Users\arnaud.dupuy\Dropbox\ITU\Application\TableRlogit.tex', 'w');
%fprintf(FID, '\\begin{tabular}{l|rrr}\\hline\\hline \n');
%fprintf(FID, '%s \\\\ \n', colLabels2');
%fprintf(FID, '%6.0f & %6.2f & %6.2f & \\\\ \n', '',FE_prod_p);
%fprintf(FID, '%s & (%6.3f) & (%6.3f) & \\\\ \n', '',t_FE_prod_p);
%fprintf(FID, '\\hline ');
%fprintf(FID, '%s & %6.2f & & \\\\ \n', 'Scale',weig);
%fprintf(FID, '%s & (%6.3f) & & \\\\ \n', '',t_weig);
%fprintf(FID, '\\hline\\hline ');
%fprintf(FID, '\n');
%fprintf(FID, '\\end{tabular}\n');
%fclose(FID);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%% Checking the quality of wage fit %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%% Comparing with simple OLS wage regression on cons and X*Y %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%FIRST CHECKING THE OCCURRENCE OF NEGATIVE WAGES %%%%%%%%%%%%%%%%%%%%%%
[Pi_hat,WA_hat] = Simualtion_Pij_Transfer(N,K_A,K_G,Aopti,SPY,tEx,tEy,tFy,X,PX,Y,PY,PY_tilda,AM);
N*diag(Pi_hat);
WA = diag(WA_hat);
min(WA_hat')';


[neg_wages] = NegWages(WA_hat,Pi_hat);
%[neg_wages] = NegWages(WA_s_inter,Pi_hat);
max(neg_wages(:,1));
max(neg_wages(:,2));

Percentage_of_negative_wages = sum(neg_wages(:,1))/N
value_max_likelihood = -minus_Fval

horzcat(w,WA,N*sum(WA_hat.*Pi_hat,2),neg_wages(:,2))

%%write data
varia = {'cum_neg_wages' 'counts_neg_wages'};
data_neg_wages = neg_wages;

sheet = 1;
xlRange = 'A1';
xlswrite('data_negative_wages_estimation',varia,sheet,xlRange);
xlRange = 'A2';
xlswrite('data_negative_wages_estimation',data_neg_wages,sheet,xlRange);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%Check by firms%%%%%%
numb_neg_wgae_firms=zeros(115,1);
share_neg_wgae_firms= sum(115*Pi_hat.*(WA_hat<0));
%share_neg_wgae_firms= sum(115*Pi_hat.*(WA_s_inter<0));

for i=1:115
    numb_neg_wgae_firms(i) = sum(WA_hat(:,i)<0);
    %numb_neg_wgae_firms(i) = sum(WA_s_inter(:,i)<0);
end
numb_neg_wgae_firms
share_neg_wgae_firms'*100
sum(share_neg_wgae_firms)/115*100


[lambdaEx_s,X_tilda_s,PY_tilda_s,BF_A_tilda_s,Ybis_s,lambdaFy_s,Y_tilda_s,BF_G_tilda_s,BF_Gbis_s] = GenBFTilde(tEx_s,tEy_s,tFy_s,X,PX,Y,PY,AM);
X_A_var = reshape(BF_A_tilda_s,[N*N,K_A]);
X_G_var = reshape(BF_G_tilda_s,[N*N,K_G]);
Y_var = reshape(WA_hat,[N*N,1]);
Y_var = (Y_var<0);
%percentage of neg cells
Percent_Neg_wages = sum(sum(Y_var))/N/N*100

Y_coach = sum(WA_hat<0,2)>0;
Y_team = (sum(WA_hat<0,1)>0)';

[b_coach,bint] = regress(Y_coach,horzcat(Xtrans,ones(N,1)))
[b_team,bint] = regress(Y_team,horzcat(Ytrans,ones(N,1))) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%THEN CHECKING THE WAGE FIT%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if lognorm ==0
    fw = w;
    fWA = WA;
else
    fw = log(w);
    fWA = log(WA);
end
err_model = fw - fWA;
zeross = zeros(N,1);
mean(err_model)
plot(fw,fWA,'ko',fw,fw,'-b')
title('Fitted on true wages')

r_sq = 1 - var(err_model) / var(fw)
var(err_model)
var(fw)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%McFadden's pseudo R2 here: Rmc = 1 - log(Lmodel)/log(constantModel)
[~,IG] = sort(P);%sort by ascending order
gammaConst_ii = zeros(N,1);
logL3Const_ii = gammaConst_ii(IG,1) - log(cumsum(exp(gammaConst_ii(IG,1))));
j = 0:N-maxRank-1;
NmaxRankj = log(N-maxRank-j);
logL3Const = sum(logL3Const_ii(N-maxRank+1:N,1))-sum(NmaxRankj)
logL3
RMcF = 1 - logL3/logL3Const

[Aa,Ga,t,weig,para_FEY]=ReadParameters(K_A,K_G,Aopti,SPY);
[auxA,auxG,auxGbis,auxPHI] = GenUtilities(N,K_A,K_G,BF_A_tilda,Aa,BF_G_tilda,Ga,BF_Gbis);
gamma_ii = diag(auxGbis);
[~,IG_h] = sort(gamma_ii);%sort by ascending order
[~,rank_P] = sort(IG);
[~,rank_gamma] = sort(IG_h);

di = (rank_P - rank_gamma).^2;
spearman = 1 - 6*sum(di)/(N*(N^2-1))

indices = rank_P>=N-maxRank+1;

newP = P(indices);
newG = gamma_ii(indices);
[~,newIG] = sort(newP);
[~,newIG_h] = sort(newG);
[~,newrank_P] = sort(newIG);
[~,newrank_gamma] = sort(newIG_h);
newdi = (newrank_P - newrank_gamma).^2;
newspearman = 1 - 6*sum(newdi)/(maxRank*(maxRank^2-1))

horzcat(newP,newG,newrank_P,newrank_gamma);

%Some stats to check quality of ROLOGIT fit
[RHO,PVAL] = corrcoef(newP,newG)
xx = horzcat(ones(maxRank,1),newG);
yy = newP;
betas = (xx'*xx)\(xx'*yy);
yy_hat = xx*betas;
sumresi_sq = sum((yy-yy_hat).^2)/(maxRank-2);
std_betas = (diag(inv(xx'*xx).*sumresi_sq)).^0.5;
ttset_slope = betas(2)/std_betas(2)
plot(newG,newP,'ko',newG,yy_hat,'-b')
title('Fitted performance')

plot(newrank_gamma,newrank_P,'ko')
title('Fitted performance')

%plot(rank_gamma(indices),rank_P(indices),'ko')
%title('Fitted performance')

LEX = lambdaEx.*ones(N,1);
LFY = lambdaFy.*ones(N,1);

%%write data
varia = {'X1' 'X2' 'X3' 'Y1' 'Y2' 'Y3' 'lambdaEx' 'lambdaFy' 'tEy'};
data_simu = horzcat(X,Y,LEX,LFY,tEy);

sheet = 1;
xlRange = 'A1';
xlswrite('data_simulation_alfred',varia,sheet,xlRange);
xlRange = 'A2';
xlswrite('data_simulation_alfred',data_simu,sheet,xlRange);

%%write parameters
sheet = 1;
xlRange = 'A1';
varia = {'Alpha'};
xlswrite('parameters_simulation_alfred',varia,sheet,xlRange);
xlRange = 'A2';
xlswrite('parameters_simulation_alfred',ALPHA,sheet,xlRange);

sheet = 2;
xlRange = 'A1';
varia = {'Fixed effects (Y,Y^2,Y^3) Alpha'};
xlswrite('parameters_simulation_alfred',varia,sheet,xlRange);
xlRange = 'A2';
xlswrite('parameters_simulation_alfred',FEy,sheet,xlRange);

sheet = 3;
xlRange = 'A1';
varia = {'Gamma'};
xlswrite('parameters_simulation_alfred',varia,sheet,xlRange);
xlRange = 'A2';
xlswrite('parameters_simulation_alfred',GAMMA,sheet,xlRange);

sheet = 4;
xlRange = 'A1';
varia = {'Fixed effects X Gamma'};
xlswrite('parameters_simulation_alfred',varia,sheet,xlRange);
xlRange = 'A2';
xlswrite('parameters_simulation_alfred',FEx,sheet,xlRange);

sheet = 5;
xlRange = 'A1';
varia = {'Scale RLOGIT'};
xlswrite('parameters_simulation_alfred',varia,sheet,xlRange);
xlRange = 'A2';
xlswrite('parameters_simulation_alfred',weig,sheet,xlRange);
varia = {'fixed effects X RLOGIT'};
xlRange = 'B1';
xlswrite('parameters_simulation_alfred',varia,sheet,xlRange);
xlRange = 'B2';
xlswrite('parameters_simulation_alfred',FE_prod,sheet,xlRange);

sheet = 6;
xlRange = 'A1';
varia = {'Constant Wage reg, t'};
xlswrite('parameters_simulation_alfred',varia,sheet,xlRange);
xlRange = 'A2';
xlswrite('parameters_simulation_alfred',t,sheet,xlRange);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%END%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%