%Procedure for obtaining the gradient of log-like
function [dlnL1_dA,dlnL1_dG,dlnL2_dA,dlnL2_dG,dlnL2_dt] = GradLogLike(BF_A,BF_G,hetero_scale_ij,Pij,w,deltai)
%function [dlnL1_dA,dlnL1_dG,dlnL2_dA,dlnL2_dG] = GradLogLike(BF_A,BF_G,hetero_scale_ij,Pij,w,deltai)
global sigma1_stor sigma2_stor dlnL2_old_dA_dfwages_dA dlnL2_old_dA_deltai gra_old_da_tilda_dA gra_old_da_tilda_dG gra_old_db_tilda_dA gra_old_db_tilda_dG
global dfwages lognorm
[~,~,K_A]=size(BF_A);
[~,N,K_G]=size(BF_G);

dPHI_tilda_dA = zeros(N,K_A);
dPHI_tilda_dG = zeros(N,K_G);
for k = 1 : K_A
    mati_A = BF_A(:,:,k);
    dPHI_tilda_dA(:,k) = diag(mati_A);
end
for k = 1 : K_G
    mati_G = BF_G(:,:,k);
    dPHI_tilda_dG(:,k) = diag(mati_G);
end
dALPHA_tilda_dA = dPHI_tilda_dA;
dGAMMA_tilda_dG = dPHI_tilda_dG;
[da_tilda_dA,da_tilda_dG,db_tilda_dA,db_tilda_dG] = GradPotential_hetero(BF_A,BF_G,Pij,hetero_scale_ij);

%gradient LnL1 (matching equation)
dlnL1_dA = sum((dPHI_tilda_dA-(da_tilda_dA+db_tilda_dA))./hetero_scale_ij,1)';
dlnL1_dG = sum((dPHI_tilda_dG-(da_tilda_dG+db_tilda_dG))./hetero_scale_ij,1)';

%gratient LnL2 (wage equation)
sigma1_tilda = sigma1_stor./hetero_scale_ij;
sigma2_tilda = sigma2_stor./hetero_scale_ij;
dwages_tilda_dA = -db_tilda_dA*sigma1_tilda + (da_tilda_dA - dALPHA_tilda_dA)*sigma2_tilda;
dwages_tilda_dG = (dGAMMA_tilda_dG - db_tilda_dG)*sigma1_tilda + da_tilda_dG*sigma2_tilda;
dwages_dA = dwages_tilda_dA;
dwages_dG = dwages_tilda_dG;
dwages_tilda_dt = ones(N,1);
dwages_dt = dwages_tilda_dt;

UA = zeros(N,K_A);
UG = zeros(N,K_G);
if lognorm == 0
    dfwages_dA = dwages_dA;
    dfwages_dG = dwages_dG;
    dfwages_dt = dwages_dt;
else
    for k = 1 : K_A
        UA(:,k) = w;
    end
    for k = 1 : K_G
        UG(:,k) = w;
    end
    UT=w;
    dfwages_dA=dwages_dA./UA;
    dfwages_dG=dwages_dG./UG;
    dfwages_dt=dwages_dt./UT;
end

dfwages = horzcat(dfwages_dA,dfwages_dG,dfwages_dt);
%dfwages = horzcat(dfwages_dA,dfwages_dG);

%Formula for gradient of lnL2
dlnL2_dA = dfwages_dA'*deltai;

%checking gradient L2 composition
dlnL2_old_dA_dfwages_dA = dfwages_dA;
dlnL2_old_dA_deltai = deltai;
gra_old_da_tilda_dA = da_tilda_dA;
gra_old_da_tilda_dG = da_tilda_dG;
gra_old_db_tilda_dA = db_tilda_dA;
gra_old_db_tilda_dG = db_tilda_dG;
%%%%

dlnL2_dG = dfwages_dG'*deltai;
dlnL2_dt = dfwages_dt'*deltai;

end