function [BF_A,BF_G] = GenBFTilde_QE(X,PX,Y,PY)
global specification mx_A my_A mx_G my_G
global interactions

PY_tilda = PY;

if specification == 1
    %full specification: all x's and all y's are used for the alpha and
    %gamma terms of the surplus
interactions = 1;

X_inter_tilda = X;
Y_inter = Y;

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X;

[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X

end

if specification == 2
   %same specification for alpha and gamma, Y (risk and public) X, (educ,expe and Union)
interactions = 1;
    
X_inter_tilda = X(:,[1 2 5]);
Y_inter = Y;

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X(:,[1 2 5]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end

if specification == 3
    %Different specification for alpha and gamma: for alpha we use risk and public dummy for y and education, experience and marital status (X1, X2 and X4 respectively)
    %while for gamma we use risk and public dummy for y and education, experience and union membership  (X1, X2 and X5 respectively)
interactions = 1;
    
X_inter_tilda = X(:,[1 2 4]);
Y_inter = Y;

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X(:,[1 2 5]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end

if specification == 4
    %Different specification for alpha and gamma: for alpha we use risk and public dummy for y and education, experience (X1 and X2 respectively)
    %while for gamma we use risk and public dummy for y and education, experience and union membership  (X1, X2 and X5 respectively)
interactions = 1;

X_inter_tilda = X(:,[1 2]);
Y_inter = Y;

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X(:,[1 2 5]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end


if specification == 5
    %For alpha we use only risk for y and education, experience and Gender in X (X1, X2 and X3). For Gamma we use risk and public dummy as Y (Y1 and Y2) and education, experience and union membership (X1, X2 and X5 respectively)
interactions = 1;

X_inter_tilda = X(:,[1 2 3]);
Y_inter = Y(:,1);

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X(:,[1 2 5]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end

if specification == 6
    %For alpha we use only risk for y and education, experience and Gender in X (X1, X2 and X3). For Gamma we use public dummy as Y (Y2) and education, experience and union membership (X1, X2 and X5 respectively)
interactions = 1;
    
X_inter_tilda = X(:,[1 2 3]);
Y_inter = Y(:,1);

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y(:,2);
X_inter = X(:,[1 2 5]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end

if specification == 7
    %Different specification for alpha and gamma: for alpha we use risk and public dummy for y and education, gender (X1 and X3 respectively)
    %while for gamma we use risk and public dummy for y and education, experience and union membership  (X1, X2 and X5 respectively)
interactions = 1;

X_inter_tilda = X(:,[1 3]);
Y_inter = Y;

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X(:,[1 2 5]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end

if specification == 8
    %Different specification for alpha and gamma: for alpha we use risk and public dummy for y and gender (X1 and X3 respectively)
    %while for gamma we use risk and public dummy for y and education, experience and union membership  (X1, X2 and X5 respectively)
interactions = 1;

X_inter_tilda = X(:,3);
Y_inter = Y;

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X(:,[1 2 5]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end

if specification == 9
    %Different specification for alpha and gamma: for alpha we use risk and public dummy for y and education for X (X1 respectively)
    %while for gamma we use risk and public dummy for y and education, experience and union membership  (X1, X2 and X5 respectively)
interactions = 1;

X_inter_tilda = X(:,1);
Y_inter = Y;

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X(:,[1 2 5]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X 
end

if specification == 10 || specification==12
    %Different specification for alpha and gamma: For alpha we use only public for y and education for x (X1).
    %For Gamma we use risk and public dummy as Y (Y1 and Y2) and education, experience, gender (X1, X2, X3 respectively)
interactions = 1;
    
X_inter_tilda = X(:,1);
Y_inter = Y(:,2);

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X(:,[1 2 3]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end

if specification == 11
    %No interaction
interactions = 0;

mx_A = 0;
my_A = 0;

[N,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
%BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = BF_A_Y;%Includes interaction X*Y plus main effects in Y

mx_G = 0;
my_G = 0;

[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = BF_G_X;%includes interaction X*Y plus main effects in X
    
end



if specification == 13
    %interactions for alpha come from y (risk and public
%sector) for y and gender for X (X3), for gamma (risk and public sector) for y and education, experience for X (X1, X2)
interactions = 1;

X_inter_tilda = X(:,3);
Y_inter = Y;

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X(:,[1 2]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end

if specification == 14
    %no interactions for alpha
    %interactions for gamma (risk and public sector) for y and education, experience for X (X1, X2)
interactions = 1;

mx_A = 0;
my_A = 0;

[N,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
%BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = BF_A_Y;%Includes interaction X*Y plus main effects in Y

Y_inter_tilda = Y;
X_inter = X(:,[1 2]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end


if specification == 15
    %%%BEWARE NEEDS TO BE COMBINED WITH YOS^2
    %Same specification for alpha and gamma using risk and public dummy for y and education, experience, gender (X1, X2, X3 respectively)
interactions = 1;
    
X_inter_tilda = X(:,[1 2 3]);
Y_inter = Y;

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X(:,[1 2 3]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end

if specification == 16
    %Same as specification 15 but without schooling squared
interactions = 1;
    
X_inter_tilda = X(:,[1 2 3]);
Y_inter = Y;

[N,mx_A]=size(X_inter_tilda);
[~,my_A]=size(Y_inter);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consX_tilda = ones(N,1);
%BF_A_XY2 = BasisFunction_XY_ML(X_tilda,Y);%this gives us alpha_tilda X*Y when multiplied by A matrix => needed in matching likelihood and wage reg
BF_A_XY = reshape(kron(Y_inter,X_inter_tilda),[N,N,mx_A*my_A]);
%max(max(max(abs(BF_A_XY-BF_A_XY2))))

%BF_A_AM = bsxfun(@times,AM,lambdaEx);%BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_A1 = cat(3,BF_A_XY,BF_A_AM);
%BF_A_Y2 = BasisFunction_XY_ML(consX_tilda,PY);%captures the fixed effects in Y
BF_A_Y = reshape(kron(PY,consX_tilda),[N,N,mpy*1]);
%max(max(max(abs(BF_A_Y-BF_A_Y2))))
%BF_A = cat(3,BF_A1,BF_A_Y);%Includes interaction X*Y plus main effects in Y
BF_A = cat(3,BF_A_XY,BF_A_Y);%Includes interaction X*Y plus main effects in Y


Y_inter_tilda = Y;
X_inter = X(:,[1 2 3]);
[N,mx_G]=size(X_inter);
[~,my_G]=size(Y_inter_tilda);
[~,mpx]=size(PX);
[~,mpy]=size(PY);

consY_tilda =ones(N,1);
%BF_G_XY2 = BasisFunction_XY_ML(X,Y_tilda);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
BF_G_XY = reshape(kron(Y_inter_tilda,X_inter),[N,N,mx_G*my_G]);%this gives us gamma_tilda X*Y when multiplied with G matrix => needed in matching likelihood and wage reg
%max(max(max(abs(BF_G_XY-BF_G_XY2))))

%BF_G_AM = bsxfun(@times,AM,lambdaFy');%ADD at the end of BF_G_XY an additional BF containing the matrix i,j  with values 1 when team j is the Alma Matter of coach i 
%BF_G1 = cat(3,BF_G_XY,BF_G_AM);
%BF_G_X2 =  BasisFunction_XY_ML(PX,consY_tilda);%captures the fixed effects in Y
BF_G_X =  reshape(kron(consY_tilda,PX),[N,N,1*mpx]);%captures the fixed effects in Y
%max(max(max(abs(BF_G_X-BF_G_X2))))
%BF_G = cat(3,BF_G1,BF_G_X);%includes interaction X*Y plus main effects in X
BF_G = cat(3,BF_G_XY,BF_G_X);%includes interaction X*Y plus main effects in X
    
end



end

