function [done] = CreateTeXTaBDesC_QE(X,Y,w)

%%%%%Stat Desc%%%%%
%Workers
X_tilda = horzcat(X,w);
[Nworkers,varX]=size(X_tilda);
meanX=mean(X_tilda);
minX=min(X_tilda);
maxX=max(X_tilda);
stdX=sqrt(diag(cov(X_tilda)));
statdesc_X = horzcat(meanX',stdX, minX', maxX');

%Firms
Y_tilda = horzcat(Y);
[Nfirms,varY]=size(Y_tilda);
meanY=mean(Y_tilda);
minY=min(Y_tilda);
maxY=max(Y_tilda);
stdY=sqrt(diag(cov(Y_tilda)));
statdesc_Y = horzcat(meanY',stdY, minY', maxY');

StatDesc = vertcat(statdesc_X,statdesc_Y);

%NEED TO CHANGE THE LABELS HERE BELOW!!!!!!!

rowLabels = char('Years of Schooling (in years)', 'Experience (in years)', 'Female','Married','White','Black','Asian','Wage (hourly)','Risk (per 100,000)','Public');
%'YoS (in years)', 'Experience (in years)', '', 'Salaries (in \$M)', 'Coaches at Alma Mater', 'Revenues from sports (in \$M)','Operating expenses (in \$M)', 'Performance: Principal Component');
%FID = fopen('C:\Users\arnaud.dupuy\Dropbox\ITU\Application\Tables\TableDesc.tex', 'w');
FID = fopen('Outputs\TableDesc1.tex', 'w');
%fprintf(FID, '\\begin{tabular}{l|rrrr}\\hline\\hline \n');
fprintf(FID, '  & Mean & Std & Min & Max \\\\ \\hline \n');
fprintf(FID, 'Workers &  & & &  \\\\  \n');
for k = 1:varX
    fprintf(FID, '%s  & %6.2f & %6.2f  & %6.2f & %6.2f \\\\ \n', rowLabels(k,:),StatDesc(k,:));
end
fprintf(FID, '\\hline ');
fprintf(FID, 'Firms &  & & & \\\\  \n');
for k = varX+1:varX+varY
    fprintf(FID, '%s &   %6.2f & %6.2f  & %6.2f & %6.2f \\\\ \n', rowLabels(k,:),StatDesc(k,:));
end  
fprintf(FID, '\\hline ');
fprintf(FID, '%s &   %4.0f & %s  & %s & %s \\\\ \n', 'N',Nworkers,'','','');

fprintf(FID, '\\hline\\hline');
fprintf(FID, '\n');
%fprintf(FID, '\\end{tabular}\n');
fclose(FID);

done = 1;
end

