function [X,Y,wage]=extract_data_QE(data_all)
global StdRisk AveRisk meanW meanW_wo AveRisk_wo StdRisk_wo incl_pub
% Order of variables: 
% 1 wage
% 2 x_educ	
% 3 x_experience
% 4 x_ethnic, *White : ethn = 1, black : ethn=2, Asian:ethn==3, Hispanic: ethn==4, Other: ethn==5
% 5 x_gender, 0 male, 1 female
% 6 x_marital, 1 if married, 0 otherwise.
% 7 x_city
% 8 x_region 
% 9 x_unionmember, 0 no, 1 yes.
% 10 y_hostpital
% 11 y_risk (per 100,000)
% 12 y_public, 0 private, 1 public
% 13 x_white, 1 if white 0 otherwise
% 14 x_black, 1 if black 0 otherwise
% 15 x_asian, 1 if asian 0 otherwise

%data_all(:,11)=100*data_all(:,11);%risk is now in "per 100,000"

%ALWAYS PUT THE NONCATEGORICAL VARIABLES FIRST, AND INDICATE THE NUMBER OF
%CATEGORICAL VARIABLES IN _cat.
%x_cat = 1;
%X = horzcat(data_all(:,2),data_all(:,3),data_all(:,5));
x_cat = 5;
%x_cat = 0;
%1 year_of_schooling, 2 years_of_experience (age), 3 gender, 4 marital status, 5 white, 6 black, 7 asian 
X = horzcat(data_all(:,2),data_all(:,3),data_all(:,5),data_all(:,6),data_all(:,13),data_all(:,14),data_all(:,15));
%incl public sector var into analysis
if incl_pub==1
    y_cat = 1;
    Y = horzcat(data_all(:,11),data_all(:,12));
else
    y_cat=0;
    Y = horzcat(data_all(:,11));
end

wage = data_all(:,1);
meanW =  mean(wage);
woman = data_all(:,5)==1;
wage_wo = wage(woman,1);
meanW_wo = mean(wage_wo);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% Report Statistics  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Correlations
%[ done ] = pairwiseCorr(Y,X,w);
% TeX tables of summary statas
[done] = CreateTeXTaBDesC_QE(X,Y,wage);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% Standardizing the variables %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Rescaling of the data
[~,Mx]=size(X);
[~,My]=size(Y);
%Only non catagorical var
[X(:,1:Mx-x_cat),~,~]=normalize(X(:,1:Mx-x_cat));
[Y(:,1:My-y_cat),mY,StdY]=normalize(Y(:,1:My-y_cat));
StdRisk = StdY;
FID = fopen('Outputs\SDRisk.tex', 'w');
fprintf(FID, '%6.2f', StdRisk);
fclose(FID);
AveRisk = mY;
FID = fopen('Outputs\AveRisk.tex', 'w');
fprintf(FID, '%6.2f', AveRisk);
fclose(FID);
end