%Procedure for obtaining the gradient of potentials a and b
function [da_tilda_dA,da_tilda_dG,db_tilda_dA,db_tilda_dG] = GradPotential_hetero(BF_A,BF_G,Pij,hetero_scale_ij)
global MPi_Old EF_A_Old EF_G_Old
%Gradient of potentials: a and b wrt phi=alpha+gamma
[~,~,K_A]=size(BF_A);
[~,N,K_G]=size(BF_G);
Pij_tilda = Pij;
%./hetero_scale_ij;
%since sum_i(Pij) = 1/n = sum_j(Pij), and the system to solve is sum_i((dphij-ai)*pij)-dbj*1/n = 0, sum_j((dphij-bj)*pij)-dai*1/n = 0
%we pre-multiply Pij by n to get rid of the factor 1/n in the system to solve.
margPij_tilda_i = sum(Pij_tilda,2);
margPij_tilda_j = sum(Pij_tilda,1);
Pij_tilda_marg_i_t = bsxfun(@rdivide,Pij_tilda,margPij_tilda_i);
Pij_tilda_marg_i_t(1,:) = zeros(1,N);
Pij_tilda_marg_j_t = bsxfun(@rdivide,Pij_tilda,margPij_tilda_j);
%STEP 1: creating matrices E and F
E_A = zeros(N,K_A);
F_A = zeros(N,K_A);
for k = 1 : K_A
        mati_A = BF_A(:,:,k);
        E_A(:,k) = diag(Pij_tilda_marg_i_t*mati_A');
        F_A(:,k) = diag(Pij_tilda_marg_j_t'*mati_A);
end
E_G = zeros(N,K_G);
F_G = zeros(N,K_G);
for k = 1 : K_G
        mati_G = BF_G(:,:,k);
        E_G(:,k) = diag(Pij_tilda_marg_i_t*mati_G');
        F_G(:,k) = diag(Pij_tilda_marg_j_t'*mati_G);
end
E_A(1,:) = zeros(1,K_A);
EF_A = vertcat(E_A,F_A);
E_G(1,:) = zeros(1,K_G);
EF_G = vertcat(E_G,F_G);
%STEP 2: creates the matrix MPi = ( I Pi_t, Pi I) and inverting it into inv_mati
MPi = eye(2*N);
MPi(1:N,(1+N):(2*N)) = Pij_tilda_marg_i_t;
MPi((1+N):(2*N),1:N) = Pij_tilda_marg_j_t';
%STEP 3: formula for gradients of potentials
dab_dA = MPi \ EF_A;
dab_dG = MPi \ EF_G;
%Checking gradient L2
MPi_Old = MPi;
EF_A_Old = EF_A;
EF_G_Old = EF_G;
%%%%
da_tilda_dA = dab_dA(1:N,:);
da_tilda_dG = dab_dG(1:N,:);
db_tilda_dA = dab_dA(N+1:2*N,:);
db_tilda_dG = dab_dG(N+1:2*N,:);
end
