% function kalman_smoother_bgw_aly.m performs the Kalman smoothing given the
% estimated parameters (param_vec) and the input data (x and y_bar)
% The output are three-dimensional arrays for the state vector (xi_out), 
% its variance-covariance matrix (P_out), the prediction error (nu_out), 
% and its variance-covariance matrix (v_out), repectively  
% copyright : Emanuel Mnch, Humboldt University Berlin, June 2003, 
% Email: moench@wiwi.hu-berlin.de  

function [xi_smoothed,P_smoothed] = kalman_smoother_bgw_aly(param_vec,xi_TT_out,P_TT_out,xi_TL_out,P_TL_out);

rho = param_vec(length(param_vec)-1);

% Initialize coefficient matrices
F = vertcat([0 0 0 0 0 0 0 0 0 0 0 0 rho],[1 0 0 0 0 0 0 0 0 0 0 0 0],[0 1 0 0 0 0 0 0 0 0 0 0 0],[0 0 1 0 0 0 0 0 0 0 0 0 0],...
            [0 0 0 1 0 0 0 0 0 0 0 0 0],[0 0 0 0 1 0 0 0 0 0 0 0 0],[0 0 0 0 0 1 0 0 0 0 0 0 0],[0 0 0 0 0 0 1 0 0 0 0 0 0],...
            [0 0 0 0 0 0 0 1 0 0 0 0 0],[0 0 0 0 0 0 0 0 1 0 0 0 0],[0 0 0 0 0 0 0 0 0 1 0 0 0],[0 0 0 0 0 0 0 0 0 0 1 0 0],...
            [0 0 0 0 0 0 0 0 0 0 0 0 rho]);


% Kalman smoother recursions (following Hamilton 1994, pp. 394-397)
T = length(xi_TT_out);
xi_smoothed = xi_TT_out(:,:,T);
P_smoothed = P_TT_out(:,:,T);
t = T-1;
while t > 0,
    xi_tt = xi_TT_out(:,:,t);
    xi_tplus1t = xi_TL_out(:,:,t+1);
    xi_tplus1T = xi_smoothed(:,:,T-t);
    P_tt = P_TT_out(:,:,t);
    P_tplus1t = P_TL_out(:,:,t+1);
    P_tplus1T = P_smoothed(:,:,T-t);
    J_t = P_tt*F'*pinv(P_tplus1t);

    % Smoothing equations
    xi_tT = xi_tt + J_t*(xi_tplus1T - xi_tplus1t);
    xi_smoothed = cat(3,xi_smoothed,xi_tT);
    P_tT = P_tt + J_t*(P_tplus1T-P_tplus1t)*J_t';
    P_smoothed = cat(3,P_smoothed,P_tT);
    
    t = t - 1;
end;


