;----------------------------------------------------------------------------
; EBook         STF
; 
;----------------------------------------------------------------------------
; See_also      cdfstab, pdfstab, stabreg
;
;----------------------------------------------------------------------------
; Macro         STFstab07
; 
;----------------------------------------------------------------------------
; Description   stable and Gaussian fits to returns of Boeing stock price
; 
;---------------------------------------------------------------------------- 


library("distribs")
library("stats")

x=read("boeing.dat")
y = (x[2:rows(x),2] - x[1:rows(x)-1,2])./x[1:rows(x)-1,2]
y = sort(y)
n = rows(y)
F = (1:n)/n ; empirical cdf

; estimation of parameters
w = stabreg(y)
st = cdfstab(y,w.alpha,w.sigma,w.beta,w.mu)

mu = mean(y)
si = sqrt(var(y))
gs = cdfn((y-mu)/si)

nad = adstat(y,gs)
sad = adstat(y,st)
nk  = kstat(y,gs)
sk  = kstat(y,st)

out1  = "                 Stable fit               "
out2  = "Parameters                                "
out3  = "alpha            "+string("%1.4f",w.alpha )+ "                   " 
out4  = "sigma            "+string("%1.4f",w.sigma )+ "                   " 
out5  = "beta             "+string("%1.4f",w.beta )+ "                   " 
out6  = "mu               "+string("%1.4f",w.mu )+ "                   " 
out7  = "                 test value               " 
out8  = "Anderson-Darling "+string("%4.4f",sad.cval)+ "                   " 
out9  = "Kolmogorov       "+string("%4.4f",sk.cval) + "                   "
out10 = "                                          " 
out11 = "                 Gaussian fit             "
out12 = "Parameters                                "
out13 = "mean             "+string("%1.4f",mu )+ "                   " 
out14 = "std              "+string("%1.4f",si )+ "                   " 
out15 = "                 test value               " 
out16 = "Anderson-Darling "+string("%4.4f",nad.cval)+ "                   " 
out17 = "Kolmogorov       "+string("%4.4f",nk.cval) + "                   "
output = out1|out2|out3|out4|out5|out6|out7|out8|out9
output =output|out10|out11|out12|out13|out14|out15|out16|out17
output

ps = y~st
pn = y~gs
emp= y~F
ps = ps[10:rows(ps)-10,]
pn = pn[10:rows(pn)-10,]
emp= emp[10:rows(emp)-10,]
pn = setmask(pn,"line","red","thin","dashed")
ps = setmask(ps,"line","cyan")
d1 = createdisplay(1,1)
show(d1,1,1,emp,ps,pn)
setgopt(d1,1,1, "title", "Stable and Gaussian fit to Boeing returns")
setgopt(d1,1,1, "xlabel", "x", "ylabel", "CDF(x)") 
setgopt(d1,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(d1,1,1, "border", 0)

ps = abs(y)~st
pn = abs(y)~gs
emp= abs(y)~F
ps = log(ps[1:0.4*rows(ps),])
pn = log(pn[6:0.4*rows(pn),])
emp= log(emp[1:0.4*rows(emp),])
pn = setmask(pn,"line","red","thin","dashed")
ps = setmask(ps,"line","cyan")
d2 = createdisplay(1,1)
show(d2,1,1,emp,ps,pn)
setgopt(d2,1,1, "title", "Stable, Gaussian, and empirical left tails")
setgopt(d2,1,1, "xlabel", "log(x)", "ylabel", "log(CDF(x))") 
setgopt(d2,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(d2,1,1, "border", 0)


