;----------------------------------------------------------------------------
; EBook         STF
; 
;----------------------------------------------------------------------------
; See_also      rndsstab, rndstab, hillgp1diag 
;
;----------------------------------------------------------------------------
; Macro         STFstab05
; 
;----------------------------------------------------------------------------
; Description   plots of the Hill statistics of stable samples 
; 
;---------------------------------------------------------------------------- 

library("distribs")
library("plot")
library("finance")

randomize(10)
alpha = 1.8
N = 10^6
x=rndsstab(alpha,1,N)
k = 40:2000
r=hillgp1diag(x,k)
z6=k~r
z6=setmask(z6,"line","blue")
a6=k~(k*0+alpha)
a6=setmask(a6,"line","red","thick","style",2)

k = k|(11:1000)*100
r=hillgp1diag(x,k)
z61=k~r
z61=setmask(z61,"line","blue")
a61=k~(k*0+alpha)
a61=setmask(a61,"line","red","thick","style",2)

N = 10^4
x=rndsstab(alpha,1,N)
k = 40:1000
r=hillgp1diag(x,k)
z4=k~r
z4=setmask(z4,"line","blue")
a4=k~(k*0+alpha)
a4=setmask(a4,"line","red","thick","style",2)

d1 = createdisplay(1,1)
show(d1,1,1,z4,a4)
setgopt(d1,1,1, "title", "Sample of size N=10^4")
setgopt(d1,1,1, "xlabel", "Order statistics", "ylabel", "alpha") 
setgopt(d1,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(d1,1,1, "border", 0)

d2 = createdisplay(1,1)
show(d2,1,1,z61,a61)
setgopt(d2,1,1, "title", "Sample of size N=10^6")
setgopt(d2,1,1, "xlabel", "Order statistics", "ylabel", "alpha") 
setgopt(d2,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(d2,1,1, "border", 0)

d3 = createdisplay(1,1)
show(d3,1,1,z6,a6)
setgopt(d3,1,1, "title", "Sample of size N=10^6")
setgopt(d3,1,1, "xlabel", "Order statistics", "ylabel", "alpha") 
setgopt(d3,1,1, "xvalue", 0|1, "yvalue", 0|1,"xmajor",1000) 
setgopt(d3,1,1, "border", 0)


