;----------------------------------------------------------------------------
; EBook         STF
; 
;----------------------------------------------------------------------------
; See_also      rndstab, rndsstab
;
;----------------------------------------------------------------------------
; Macro         STFstab04
; 
;----------------------------------------------------------------------------
; Description   a double logarithmic plot of right tail of an empirical 
;               symmetric stable distribution function
;---------------------------------------------------------------------------- 

library("distribs")
library("plot")
library("stats")

randomize(400)
; 10^6 sampes
x = rndsstab(1.9,1,10^6)
x = sort(x)
F = 1:(rows(x))
F = F./(rows(x)) ; empirical cdf
k = paf(1:rows(x),x>exp(-5))
x = x[k]
F = F[k]
D = x~1-F
D =log(D)
D2 = D[0.88*rows(D):0.993*rows(D),] 
D3 = D[0.997*rows(D):rows(D)-20,] 
b1=linreg(D2[,1],D2[,2],"notext")  
b2=linreg(D3[,1],D3[,2],"notext")
L1=grlinreg(D2,4)
L2=grlinreg(D3,4)
k = (1:rows(D)/100)*100|rows(D)-50:rows(D)-10




D = D[k,] 

white=setmask(D,"white")
D=setmask(D,"line","blue","thin","style",2)


; 10^4 samples
x = rndsstab(1.9,1,10^4)
x = sort(x)
F = 1:(rows(x))
F = F./(rows(x)) ; empirical cdf
k = paf(1:rows(x),x>exp(-5))
x = x[k]
F = F[k]
C = x~1-F
C =log(C)
C2 = C[0.85*rows(C):rows(C)-10,] 
c1=linreg(C2[,1],C2[,2],"notext")
L3=grlinreg(C2,4)
C=setmask(C,"line","blue","thin","style",2)

d1 = createdisplay(1,1)
show(d1,1,1,C,L3,white)
setgopt(d1,1,1, "title", "Sample of size N=10^4")
setgopt(d1,1,1, "xlabel", "log(x)", "ylabel", "log(1-CDF(x))") 
setgopt(d1,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(d1,1,1, "border", 0) 

d2 = createdisplay(1,1)
show(d2,1,1,D,L1,L2)
setgopt(d2,1,1, "title", "Sample of size N=10^6")
setgopt(d2,1,1, "xlabel", "log(x)", "ylabel", "log(1-CDF(x))") 
setgopt(d2,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(d2,1,1, "border", 0) 

out1 = "Tail index estimation; alpha = -slope "  
out2 = "10^6 samples                          " 
out3 = string("%10.4f",b1[2,])+"                            "
out4 = string("%10.4f",b2[2,])+"                            "
out5 = "10^4 samples                          " 
out6 = string("%10.4f",c1[2,])+"                            "
output = out1|out2|out3|out4|out5|out6
output


