;----------------------------------------------------------------------------
; EBook         STF
; 
;----------------------------------------------------------------------------
; See_also      pdfstab
;
;----------------------------------------------------------------------------
; Macro         STFstab03
; 
;----------------------------------------------------------------------------
; Description   comparison of S and S0 parameterizations
; 
;---------------------------------------------------------------------------- 

library("distribs")
library("plot")
x = (-50:50)/11
alpha = #(0.5,0.75,1,1.25,1.5)
beta =  0.5


; S parametrization
mu = 0*alpha

w = pdfstab(x,alpha[1],1,beta,mu[1])
s1 = setmask(x~w,"line","black","thin","solid")
w = pdfstab(x,alpha[2],1,beta,mu[2])
s2 = setmask(x~w,"line","red","medium","style",2)
w = pdfstab(x,alpha[3],1,beta,mu[3])
s3 = setmask(x~w,"line","blue","thin","style",4)
w = pdfstab(x,alpha[4],1,beta,mu[4])
s4 = setmask(x~w,"line","green","medium","dashed")
w = pdfstab(x,alpha[5],1,beta,mu[5])
s5 = setmask(x~w,"line","cyan","thin","style",14)

; S0 parametrization
mu = -beta*tan(0.5*pi.*alpha) 
mu[3] = 0

w = pdfstab(x,alpha[1],1,beta,mu[1])
s01 = setmask(x~w,"line","black","thin","solid")
w = pdfstab(x,alpha[2],1,beta,mu[2])
s02 = setmask(x~w,"line","red","medium","style",2)
w = pdfstab(x,alpha[3],1,beta,mu[3])
s03 = setmask(x~w,"line","blue","thin","style",4)
w = pdfstab(x,alpha[4],1,beta,mu[4])
s04 = setmask(x~w,"line","green","medium","dashed")
w = pdfstab(x,alpha[5],1,beta,mu[5])
s05 = setmask(x~w,"line","cyan","thin","style",14)

d1 = createdisplay(1,1)
show(d1,1,1,s1,s2,s3,s4,s5)
setgopt(d1,1,1, "title", "S parameterization")
setgopt(d1,1,1, "xlabel", "x", "ylabel", "PDF(x)") 
setgopt(d1,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(d1,1,1, "border", 0) 

d2 = createdisplay(1,1)
show(d2,1,1,s01,s02,s03,s04,s05)
setgopt(d2,1,1, "title", "S0 parameterization")
setgopt(d2,1,1, "xlabel", "x", "ylabel", "PDF(x)") 
setgopt(d2,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(d2,1,1, "border", 0) 


