;----------------------------------------------------------------------------
; EBook         STF
; 
;----------------------------------------------------------------------------
; See_also      pdfstab 
;
;----------------------------------------------------------------------------
; Macro         STFstab02
; 
;----------------------------------------------------------------------------
; Description   a) creates a plot of stable probability density  function for 
;               different betas  
;    		b) plot of probability density functions of  
;               Gaussian, Cauchy and Levy distributions   
;---------------------------------------------------------------------------- 

library("distribs")
library("plot")
x = (-50:50)/10 
alpha = 1.2
beta = #(0,0.5,0.8,1)
w = pdfstab(x,alpha,1,beta[1],0)
s1 = setmask(x~w,"line","black","thin","solid")
w = pdfstab(x,alpha,1,beta[2],0)
s2 = setmask(x~w,"line","red","medium","style",2)
w = pdfstab(x,alpha,1,beta[3],0)
s3 = setmask(x~w,"line","blue","thin","style",4)
w = pdfstab(x,alpha,1,beta[4],0)
s4 = setmask(x~w,"line","green","medium","dashed")
d1 = createdisplay(1,1)
show(d1,1,1,s1,s2,s3,s4)
setgopt(d1,1,1, "title", "Dependence on beta ")
setgopt(d1,1,1, "xlabel", "x", "ylabel", "PDF(x)") 
setgopt(d1,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(d1,1,1, "border", 0) 

;--------------

x = (-50:50)/10
n = pdfn(x)
s1 = setmask(x~n,"line","black","thin","solid")
c = pdfcauch(x,1,0)
s2 = setmask(x~c,"line","red","medium","style",2)
l = pdflevy(x,1,0)
s3 = setmask(x~l,"line","blue","thin","style",4)
d2 = createdisplay(1,1)
show(d2,1,1,s1,s2,s3)
setgopt(d2,1,1, "title", "Gaussian, Cauchy, and Levy distributions")
setgopt(d2,1,1, "xlabel", "x", "ylabel", "PDF(x)") 
setgopt(d2,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(d2,1,1, "border", 0) 


