;----------------------------------------------------------------------------
; EBook         STF
; 
;----------------------------------------------------------------------------
; See_also      pdfstab 
;
;----------------------------------------------------------------------------
; Macro         STFstab01
; 
;----------------------------------------------------------------------------
; Description   a) creates a semilog plot of symmetric stable probability density 
;               function for different alphas  
;   	 	b) a double logarithmic plot of right tails of symmetric stable
;               disribution functions for different alphas 
;---------------------------------------------------------------------------- 
 
library("distribs")
library("plot")
x = (-30:30)/5 
alpha = #(2,1.8,1.5,1)
w = pdfstab(x,alpha[1],1,0,0)
s1 = setmask(x~log(w),"line","black","thin","solid")

x = (-50:50)/5 
w = pdfstab(x,alpha[2],1,0,0)
s2 = setmask(x~log(w),"line","red","medium","style",2)
w = pdfstab(x,alpha[3],1,0,0)
s3 = setmask(x~log(w),"line","blue","thin","style",4)
w = pdfstab(x,alpha[4],1,0,0)
s4 = setmask(x~log(w),"line","green","medium","dashed")
d1 = createdisplay(1,1)
show(d1,1,1,s1,s2,s3,s4)
setgopt(d1,1,1, "title", "Dependence on alpha ")
setgopt(d1,1,1, "xlabel", "x", "ylabel", "log(PDF(x))") 
setgopt(d1,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(d1,1,1, "border", 0) 


;------------

alpha = #(2,1.95,1.8,1.5)

x1 = (5:60)/10
x2 = (1:200)/20 + 60/10 
x = x1|x2
w = cdfstab(x1,alpha[1],1,0,0)
s1= x1~(1-w)
s1 = setmask(log(s1),"line","black","thin","solid")

w = cdfstab(x,alpha[2],1,0,0)
s2= x~(1-w)
s2 = setmask(log(s2),"line","red","medium","style",2)

w = cdfstab(x,alpha[3],1,0,0)
s3= x~(1-w)
s3 = setmask(log(s3),"line","blue","thin","style",4)

w = cdfstab(x,alpha[4],1,0,0)
s4= x~(1-w)
s4 = setmask(log(s4),"line","green","medium","dashed")

d2 = createdisplay(1,1)
show(d2,1,1,s1,s2,s3,s4)
setgopt(d2,1,1, "title", "Tails of stable laws")
setgopt(d2,1,1, "xlabel", "log(x)", "ylabel", "log(1-CDF(x))") 
setgopt(d2,1,1, "border", 0) 


