
library("VaR")
proc(mat) = thetas(data,copula,method)
  samplesize = rows(data)-1
  return=log(data[2:(samplesize+1),]./data[1:samplesize,])
  returns=-1.*return
  windowsize = 250

  t = windowsize+1

  mat=matrix(samplesize-windowsize,3)-1
  
  while (t <= samplesize)
// estimate VaR for day t using the observations in [t-windowsize, t-1]
  

  
{theta,sigma1,sigma2}=VaRfitcopula(returns[(t-windowsize):(t-1),],copula,method)
    mat[t-windowsize,1]=sigma1
    mat[t-windowsize,2]=sigma2
    mat[t-windowsize,3]=theta
  
   t=t+1
  endo
  
 
endp
proc(res)=VaRfitcopula(history,copula,method)
; ---------------------------------------------------------------------
; Library     VaR
; ---------------------------------------------------------------------
; See_also    VaRcopula VaRsimcopula VaRestMCcopula
; ---------------------------------------------------------------------
; Macro       VaRfitcopula
; ---------------------------------------------------------------------
; Description fits the copula to a given data
; ---------------------------------------------------------------------
; Usage       res = VaRfitcopula(history,copula,method)
; Input       
; Parameter   history
; Definition   n x 2 matrix, the data
; Parameter   copula
; Definition   scalar, integer between 1 and 22, selects the copula;
;                      see VaRcopula for details 
; Parameter   method
; Definition   scalar, selects the method for estimation
; 
;                method=1 returns the least squares fit for the cdf
; 
;                method=2 returns a copula maximum likelihood fit for the pdf, 
;                       using the Newton Method, fall back to 3 if it fails
; 
;                method=3 returns a copula maximum likelihood fit for the pdf, 
;                       using an interval search, slower than 2, but more stable
;
;                method=4 returns a true maximum likelihood fit for the pdf
; Output      
; Parameter   res
; Definition   list containing the estimates of the copula parameter
;              and standard deviations of two marginal Normal distributions
; ---------------------------------------------------------------------
; Example     library("VaR")
;             randomize(1)
;             x=normal(100,2)
;             VaRfitcopula(x,4,1)
; ---------------------------------------------------------------------
; Result      Contents of res.theta
;             [1,]   2.3617 
;             Contents of res.Sigma1
;             [1,]  0.98477 
;             Contents of res.Sigma2
;             [1,]  0.90471   
; ---------------------------------------------------------------------
; Keywords    copula
; -----------------------------------------------------------------
; Link      http://www.quantlet.de/scripts/XFG/html/xfghtml.html Applied Quantitative Finance
; ---------------------------------------------------------------------
; Author      J. Rank, T. Siegl, Z. Hlavka, 20010725
; ---------------------------------------------------------------------
  
  ; test JS: 20020527
  
  error(exist(history)<>1,"VaRfitcopula: first parameter must be numeric")
  error(dim(dim(history))<>2,"VaRfitcopula: wrong dimension of first parameter")
  error(cols(history)<>2,"VaRfitcopula: wrong count of columns of first parameter")
  res=zeros(3);
  Sigma=cov(history);
  Sigma1=sqrt(Sigma[1,1]);
  Sigma2=sqrt(Sigma[2,2]);
  histdim=dim(history)
  histcum=zeros(histdim[1]);
  hist1=history[,1];
  hist2=history[,2];
  dc1=cdfn(hist1/Sigma1);
  dc2=cdfn(hist2/Sigma2);
  NUMNEWTON=10;
  if (method==1)
    k=1
    while(k<=dim(hist1))
      histcum[k]=dim(indexcat(((hist1<hist1[k])&&(hist2<hist2[k])),1,1));
      k=k+1;
    endo
    hc=(histcum+0.5)/histdim[1];
    theta=VaRcopula(0~0,0,7,copula);
    i=1;
    ;hc
   while(i<=NUMNEWTON) ; sekanten-such Schritte
      htheta=theta*0.001;
      f=sum(hc-VaRcopula (dc1~dc2,theta,0,copula)).^2;
      fstrich=-2*sum((hc-VaRcopula (dc1~dc2,theta,0,copula)).*VaRcopula (dc1~dc2,theta,3,copula));
      f2strich=2*sum(VaRcopula (dc1~dc2,theta,3,copula).^2)-2*sum((hc-VaRcopula (dc1~dc1,theta,0,copula)).*VaRcopula (dc1~dc1,theta,6,copula));
      theta=theta-fstrich/f2strich;
      i=i+1;
    endo
  endif
  if (method==2)
    ; get starting point and bounds for theta
    theta=VaRcopula (0~0,0,7,copula);
    tlow=VaRcopula (0~0,0,8,copula);
    thigh=VaRcopula (0~0,0,9,copula);
    ; compute loglikelihood
    loglikelihood=sum(log(VaRcopula (dc1~dc2,theta,12,copula)));
    thetaold=theta;
    i=1;
    while (i<=NUMNEWTON) ; 10 newton steps ought to be sufficient
      ;disp(sprintf('loglikelihood=%14.7f, theta=%14.7f',loglikelihood,theta));
      llstrich=sum(VaRcopula (dc1~dc2,theta,123,copula)./VaRcopula (dc1~dc2,theta,12,copula));
      h=0.005;
      llstrich1=sum(VaRcopula (dc1~dc1,theta-h,123,copula)./VaRcopula (dc1~dc1,theta-h,12,copula));
      llstrich2=sum(VaRcopula (dc1~dc1,theta+h,123,copula)./VaRcopula (dc1~dc1,theta+h,12,copula));
      theta=theta-llstrich/(llstrich2-llstrich1)*h*2;
      llh=sum(log(VaRcopula (dc1~dc1,theta,12,copula)));
      ; if loglikelihood is becoming worse, then stop at once (we are probably unstable here)
      if (llh<loglikelihood) 
        theta=thetaold;
        i=NUMNEWTON;
      endif
      ; if all fails, try the stable method 3 (this is slow, but ought to work ok)
      if (isNaN(theta) || isNaN(llh) || isInf(theta) || isInf(llh) || (theta<=tlow) || (theta>=thigh))
        theta=VaRfitcopula(history,copula,3)(1);
        i=NUMNEWTON;
      else
        thetaold=theta;
        loglikelihood=llh;
      endif
      i=i+1;
    endo 
  endif
  if (method==3)
    ; get maximum and minimum allow theta 
    tlow=VaRcopula (0~0,0,8,copula);
    thigh=VaRcopula (0~0,0,9,copula);
    cutoff=50;
    ; thetas are often exponents, if theta too large, numerics is not very stable
    if (tlow<-cutoff) ; so cut down theta to at least -somthing
      tlow=-cutoff;
    endif   
    if (thigh>cutoff) ; and to at most something
      thigh=cutoff;
    endif
    ; Method: step through thetaspace
    steps=10;
    llh=zeros(steps,1);
    tht=zeros(steps,1);
    ; with each i we zoom into the parameterspace for the last thetarange
    ; the new thetarange is always around the maximum loglikelihood, one step
    ; before and one beyond.
    k=1;
    while(k<=NUMNEWTON)
      j=1;
      i=tlow
      while(i<=thigh);
         tht[j]=i;
         llh[j]=sum(log(VaRcopula (dc1~dc2,i,12,copula)));
         j=j+1;
         i=i+(thigh-tlow)/(steps-1);
      endo
      mllh=max(max(llh)');
      if ((mllh>1000) || (isNaN(mllh)) || (isInf(mllh)))
         theta=VaRfitcopula(history,copula,1)(1);
         I=NUMNEWTON
      else
         I=min(indexcat((llh==mllh),1,1));
         I=I+(I==-1)
         tlow=tht[max((I-1)|1)];
         thigh=tht[min((I+1)|steps)];
         theta=(thigh+tlow)/2;
      endif
      k=k+1;
    endo
    ; theta is found at the middle of the last range.
  endif
  if (method==4)
    ; get density values to use with maximum likelihood
    dp1=pdfn(hist1/Sigma1);
    dp2=pdfn(hist2/Sigma2);
    ; get maximum and minimum allow theta 
    tlow=VaRcopula (0~0,0,8,copula);
    thigh=VaRcopula (0~0,0,9,copula);
    cutoff=50;
    ; thetas are often exponents, if theta too large, numerics is not very stable
    if (tlow<-cutoff) ; so cut down theta to at least -somthing
       tlow=-cutoff;
    endif   
    if (thigh>cutoff) ; and to at most something
       thigh=cutoff;
    endif
    ; Method: step through thetaspace
    steps=10;
    llh=zeros(steps,1);
    tht=zeros(steps,1);
    ; with each i we zoom into the parameterspace for the last thetarange
    ; the new thetarange is always around the maximum loglikelihood, one step
    ; before and one beyond.
    k=1;
    while (k<=NUMNEWTON)
      j=1;
      i=tlow
      while(i<=thigh)
         tht[j]=i;
         llh[j]=sum(log(VaRcopula(dc1~dc2,i,12,copula)).*dp1.*dp2);
         j=j+1;
         i=i+(thigh-tlow)/(steps-1);
      endo
      mllh=max(max(llh));
      if ((mllh>1000) || (isNaN(mllh)) || (isInf(mllh)))
         theta=VaRfitcopula(history,copula,1)(1);
         i=NUMNEWTON
      else
         I=min(indexcat((llh==mllh),1,1));
         I=I+(I==-1)
         tlow=tht[max((I-1)|1)];
         thigh=tht[min((I+1)|steps)];
         theta=(thigh+tlow)/2;
      endif
      k=k+1;
    endo
    ; theta is found at the middle of the last range.
  endif
  res=list(theta,Sigma1,Sigma2);
endp 



setenv("xpl4outdata","G:\Copulas\Xpl\PosLoss\FXData")
data=read("fx.dat")
gumbel=4
MLEFull=4
IFM=3

;**************************RUN*************
;coppar3=thetas(data,gumbel,IFM)
;write(coppar3,"PosLossThetaFXGumbelIFM.dat","x")

