#install.packages("quantreg")
#install.packages("KernSmooth")
#library(quantreg)
#library(KernSmooth)

spacin_lprq=function(VAR1, VAR2, q = 0.05, gridn = 100){

N1<-length(VAR1)
sor_VAR2 <- VAR2[order(VAR1)] # regressand
f<-approxfun(density(VAR1)$x,density(VAR1)$y, method="linear")

index<-seq(1/N1, 1, length=N1)
h2 <- dpill(index, sor_VAR2, gridsize = gridn)
qrh2 <- 2*h2*((q*(1-q)/(dnorm(qnorm(p=q))^2))^(1/5) )
fit <- lprq(index, sor_VAR2, h=qrh2, m=gridn, tau=q)

prob<-seq(1/gridn, 1, length=gridn)
x0=quantile(VAR1, probs=prob,names=F)
y<- fit$fv*(sqrt(f(x0)))^(-1)
list(x0=x0, est=y)
}